import App from './App'

// #ifndef VUE3
import Vue from 'vue'

// #ifdef H5
import jwx from 'jweixin-module' //H5页面引入微信JSSDK，并全局挂载
Vue.prototype.$jwx = jwx
// #endif

// 引入uView并配置
import uView from 'uview-ui'
Vue.use(uView)

// 修改uView内置配置方案: 需要在Vue.use(uView)之后执行,目前只建议修改config、props属性, 除非您清楚知道自己的修改所带来的影响。
uni.$u.setConfig({
	// 修改$u.config对象的属性
	config: {
		// 修改默认单位为rpx,相当于执行 uni.$u.config.unit = 'rpx'
		unit: 'rpx'
	},
	// 修改$u.props对象的属性
	props: {
		// 修改radio组件的size参数的默认值,相当于执行 uni.$u.props.radio.size = 30
		radio: {
			size: 15
		}
		// 其他组件属性配置
		// ......
	}
})
Vue.prototype.getLocationCity = (cityInfo)=>{
	const addressIsEmpty = (add)=>{
		if (add) return add
		return ""
	}
	let cityStr = ""
	cityStr += addressIsEmpty(cityInfo['location.province'])
	if (cityInfo['location.province'] !== cityInfo['location.city']){
		cityStr += addressIsEmpty(cityInfo['location.city'])
	}
	cityStr += addressIsEmpty(cityInfo['location.district']) + addressIsEmpty(cityInfo['location.detail'])
	return cityStr
}
Vue.config.productionTip = false
App.mpType = 'app'
const app = new Vue({
	...App
})
app.$mount()
// #endif

// #ifdef VUE3
import {
	createSSRApp
} from 'vue'
export function createApp() {
	const app = createSSRApp(App)
	return {
		app
	}
}
// #endif
