import Request from "./request";
import uploadFile from "./uploadFile";
import downloadFile from "./downloadFile";

// 登录接口
// mimi: 项目名：biz-carrier-wxapp  LOGIN_ACTION: loginByUserInfo; miniAppDriverLogin/miniAppServLogin
export function userLogin(loginAction, loginCode, data) {
  return Request(
    `/api/auth/app-login/{mini}/miniAppDriverLogin?weixin_config_key={mini}&code=${loginCode}`,data
  );
}

export function userCarrierLogin(loginAction, loginCode, data) {
  return Request(
    `/api/auth/app-login/{mini}/miniAppServLogin?weixin_config_key={mini}&code=${loginCode}`,data
  );
}

//登录小程序初始化时，调用auth自动登录
export function authLogin(loginAction, loginCode, data) {
  return Request(
    `/api/auth/app-login/{mini}/miniAppCarrierAuth?weixin_config_key={mini}&code=${loginCode}`,data
  );
}
// 用户中心操作&&初始化JS-SDK  action 说明： 退出登录：logout  获取用户信息: getUserInfo 修改密码：changePassword 初始化SDK: querySignature
export function userMobileOperation(action, data) {
  if (action === "logout") {
    //退出登录
    return Request(`/logout`, data, "GET"); // data: {openId, entryName}
  } else {
    return Request(`/api/entry/{mini}/m-action/${action}`, data);
  }
}
//获取地图key
export function getMap() {
  return Request(`/api/query/*/action/getMap`);
}
//获取地图颜色
export function getMapColor(data) {
  return Request(`/api/query/biz.md.Truck/action/service-getMapColor`, data);
}
// 上传图片
export function uploadImg(data, fileType = "image") {
  return uploadFile("/api/doc/upload", data, fileType);
}
// 下载图片
export function downloadImg(data) {
  return downloadFile("/api/doc/download", data);
}

//获取基础订单信息--订舱委托
export function getOrderBaseList(data) {
   return Request(`/api/entry/{mini}/m-action/getBookingOrder`, data);
}

// 查询订舱委托订单明细
export function getOrderBaseDetail(data) {
  return Request(`/api/entry/{mini}/m-action/getBookingOrderLine`, data);
}


// 查询订舱委托订单所有节点信息
export function getOrderBaseEvent(data) {
  return Request(`/api/entry/{mini}/m-action/getBookingOrderBlEvent`, data);
}


// 查询所有船公司信息
export function queryShipownerAll(data) {
  return Request(`/api/entry/{mini}/m-action/getShipownerAll`, data);
}


// 订舱确认操作
export function updateTmBlEvent(data) {
  return Request(`/api/entry/{mini}/m-action/updateTmBlEvent`, data);
}


// 修改船期操作
export function changeShippingDateSubmit(data) {
  return Request(`/api/entry/{mini}/m-action/changeShippingDateSubmit`, data);
}

// 提货单上传操作
export function getLadingUpload(data) {
  return Request(`/api/entry/{mini}/m-action/getLadingUpload`, data);
}

//查询运单列表
export function getShipmentOrders(data) {
  return Request( `/api/entry/{mini}/m-action/getShipmentOrders`, data);
}

// 查询运单的所有节点信息
export function getShipmentEvent(data) {
  return Request(`/api/entry/{mini}/m-action/getShipmentEvent`, data);
}


//查询司机列表
export function searchDriverList(data) {
  return Request(`/api/entry/{mini}/m-action/getDriverAll`,data);
}

//查询车辆列表
export function searchTruckList(data) {
  return Request(`/api/entry/{mini}/m-action/getVehicleAll`, data);
}

//派车确认
export function getMassShipmentTruckList(data) {
  return Request(`/api/entry/{mini}/m-action/getMassShipmentTruckList`, data );
}

//查询运单途径站点
export function findShipmentStops(data) {
  return Request(
    `/api/entry/{mini}/m-action/biz.tm.ShipmentStop.tm_shipmentstop_m_carrier.paging`,
    data
  );
}

// 查询货量明细
// OM模式
export function OMOrderDetail(data) {
  return Request(
    `/api/entry/{mini}/m-action/biz.tm.OrderMovementLine.tm_ordermovementline_m_search.paging`,
    data
  );
}
// OR模式
export function OROrderDetail(data) {
  return Request(
    `/api/entry/{mini}/m-action/biz.tm.OrderLine.tm_orderline_m_search.paging`,
    data
  );
}

//查询中转地址
export function searchTransferAddress(data) {
  return Request(
    `/api/entry/{mini}/m-action/biz.md.TransferAddress.md_transferaddress_m_search.paging`,
    data
  );
}

//查询准驾车型
export function queryDrivingType() {
  return Request(`/api/query/choice.md.QuasiDrivingType/action/auto_choice`);
}
//查询车辆车型
export function queryTruckType(data) {
  return Request(
    `/api/entry/{mini}/m-action/biz.md.TruckMode.md_truckmode_m_search.paging`,
    data
  );
}


//查询道口
export function searchDockList(data) {
  return Request(
    `/api/entry/{mini}/m-action/biz.md.Dock.md_dock_m_search.paging`,
    data
  );
}

//查询道口可预约时间
export function searchDockTime(data) {
  return Request(
    `/api/entry/{mini}/m-action/biz.md.DockTimeTable.md_docktimetable_m_search.paging`,
    data
  );
}

//中转换、卸货 分配车辆司机
//action说明： 中转换车：transferAndChangeTruck 中转卸货：transferAndUnload 分配车辆司机: assign
export function reportInfo(action, data) {
  return Request(
    `/api/entry/{mini}/m-action/biz.tm.Shipment.operation.${action}`,
    data
  );
}

//司机、车辆注册
//registerType说明： 司机注册：Driver 车辆注册：Truck
export function serviceRegister(registerType, data) {
  return Request(
    `/api/entry/{mini}/m-action/biz.md.${registerType}.service.register`,
    data
  );
}

//司机、车辆详情
//action说明： 司机：Driver 车辆：Truck
export function searchDriverTruckDetail(action, data) {
  return Request(
    `/api/entry/{mini}/m-action/biz.md.${action}.md_${action.toLocaleLowerCase()}_m_page.get`,
    data
  );
}

//预约站点
export function loadDockBooking(data) {
  return Request(
    `/api/entry/{mini}/m-action/biz.tm.ShipmentStop.operation.loadDockBooking`,
    data
  );
}

//取消站点预约
export function dockBookingCancel(data) {
  return Request(
    `/api/entry/{mini}/m-action/biz.tm.ShipmentStop.operation.dockBookingCancel`,
    data
  );
}

//调度确认、取消确认 operationType: approve approveCancel
export function shipmentDispatch(operationType, data) {
  return Request(`/api/entry/{mini}/m-action/biz.tm.Shipment.operation.${operationType}`, data);
}

//签收  模式：OM：OrderMovement  OR: SimpleOrder
export function signFor(shipMode, data) {
  return Request(
    `/api/entry/{mini}/m-action/biz.tm.${shipMode}.operation.receive`,
    data
  );
}

//订单列表 OM/OR/MASS模式
export function ordermovementOM(data) {
  return Request(
    `/api/entry/{mini}/m-action/biz.tm.OrderMovement.tm_ordermovement_m_search.paging`,
    data
  );
}

export function ordermovementOR(data) {
  return Request(
    `/api/entry/{mini}/m-action/biz.tm.SimpleOrder.tm_simpleorder_m_search.paging`,
    data
  );
}

export function ordermovementMASS(data) {
  return Request(
    `/api/entry/{mini}/m-action/biz.tm.MassShipment.tm_massshipment_m_page.get`,
    data
  );
}

//修改人员详情
export function UpdateDriverInfo(data) {
  return Request(
    `/api/entry/{mini}/m-action/biz.md.Driver.service.updateInfo`,
    data
  );
}

//修改车辆详情
export function UpdateTruckInfo(data) {
  return Request(
    `/api/entry/{mini}/m-action/biz.md.Truck.service.updateInfo`,
    data
  );
}





//大宗订单车辆分配 assignType:  分配单辆车：assignTruck  分配多量车：assignTrucks
export function massAssignTruck(data, assignType) {
  return Request(
    `/api/entry/{mini}/m-action/biz.tm.MassOrderCarrier.${assignType}`,
    data
  );
}

//更新大宗订单配车
export function updateMassAssignTruck(data) {
  return Request(
    `/api/entry/{mini}/m-action/biz.tm.MassOrderTruck.service.updateOrderTrucks`,
    data
  );
}

//更新大宗订单配车
export function GetSignUrl(data) {
  return Request(
    `/api/entry/{mini}/m-action/biz.tm.OrderRelease.operation.electronicVisa`,
    data
  );
}

// 验证码发送
export function SendMessage(data) {
  return Request(`/handler/sendMessage`, data);
}

// 订单轨迹
export function findShipmentLbs(data) {
  return Request(
    `/api/entry/{mini}/m-action/biz.tm.Shipment.service.lbs`,
    data
  );
}

//获取承运商
export function GetCarrierList(data) {
  return Request(
    `/api/entry/{mini}/m-action/biz.md.Company.md_company_search.paging`,
    data
  );
}

// 百度OCR ocrType: 身份证 idCard 驾驶证 drivingLicense 行驶证 vehicleLicense
export function OCRService(ocrType, data) {
	return Request(`/api/entry/{mini}/m-action/biz.adapter.AdapterTask.service.${ocrType}`, data)
}