import AMap from '../utils/AMapUtil'; //高德工具类
import BMap from '../utils/BMapUtil'; //百度工具类
import { formatTime } from './../utils/util.js';
import { getMap, userMobileOperation } from '../api/apiList.js'

// #ifdef MP
import AMapSDK from "../utils/MapSDK/amap-wx.130"
import BMapSDK from '../utils/MapSDK/bmap-wx.min.js'
// #endif

// #ifdef H5
import AMapLoader from "@amap/amap-jsapi-loader"; //高德
// #endif

module.exports = {

	data() {
		return {
			locationInfo: {}, //用户当前位置信息
			isLocation: true, //是否获取位置中
		};
	},

	//事件处理函数
	methods: {

        //初始化地图服务
		async initMapService() {
			await this.initMapInstance()
			// #ifdef H5
			const isWxBrowser = getApp().isWxBrowser()					
			if (isWxBrowser) {
				await this.initWXH5SDK() //H5时初始化微信JSSDK, 以调用扫码、获取经纬度等功能	
			}
			// #endif
			return Promise.resolve('done');					
		},
		
		//获取地图密钥并初始化地图实例, 用于转换接口获取的经纬度为文字描述, 小程序返回MapInstance H5返回MapContext
		initMapInstance() {
			const _this = this
			return new Promise((resolve, reject) => {
				getMap().then(res => {
					//参数说明:  微信小程序KEY: wechatKey WEB地图KEY: jsKey WEB地图密钥: securityJsCode 地图服务商：BaiduMap/AMap(默认使用AMap高德服务)
					const { wechatKey, jsKey, securityJsCode, serviceProvider } = res.data.data || {}
					getApp().globalData.serviceProvider = serviceProvider
				
					// #ifdef MP
					if (!wechatKey) {
						_this.showMapTost('请在BO系统集成中配置地图的Wechat Key')
					} else {
						let newMap = null
						if(serviceProvider === 'AMap'){
							newMap = new AMapSDK.AMapWX({ key: wechatKey }) //高德地图Key
						} else {
							newMap = new BMapSDK.BMapWX({ ak: wechatKey }); //百度地图key
						}					
						getApp().globalData.MapIns = newMap
						resolve(newMap);
					}
					// #endif
				
					// #ifdef H5
					if (!jsKey) {
						_this.showMapTost('请在BO系统集成中配置地图的JS API Key')
					} else if (!securityJsCode && serviceProvider === 'AMap') { //高德无需Security秘钥
						_this.showMapTost('请在BO系统集成中配置地图的JS Security')
					} else {
						if(serviceProvider === 'AMap'){
							window._AMapSecurityConfig = { securityJsCode}
							AMapLoader.load({
								"key": jsKey, // 申请好的Web端开发者Key，首次调用 load 时必填
								"version": "2.0", // 指定要加载的 JSAPI 的版本，缺省时默认为 1.4.15
								"plugins": ["AMap.Marker", "AMap.Pixel","AMap.Geocoder","AMap.Geolocation"], // 需要使用的的插件列表，如比例尺'AMap.Scale'等
							}).then(async (AMapCtx) => {							
								getApp().globalData.MapIns = AMapCtx
								resolve(AMapCtx);
							}).catch(err => {
								_this.showMapTost(err, 'errrr')							
							});
						} else {			
							const BMap_URL = `https://api.map.baidu.com/api?v=2.0&ak=${jsKey}&callback=onBMapCallback`;
							// 插入script脚本
							let scriptNode = document.createElement("script");	
							scriptNode.type="text/javascript";			
							scriptNode.setAttribute("src", BMap_URL);
							document.body.appendChild(scriptNode);
							
							// 百度地图异步加载回调处理
							window.onBMapCallback = function() {
								getApp().globalData.MapIns = window.BMap
								resolve(window.BMap);
							};
						}
					}
					// #endif
				
					// APP && PDA端需引入指定定位SDK, 暂未兼容地图及定位服务
					// #ifdef APP-PLUS
				
					// #endif					
				})
			})
		},

		//弹窗提示
		showMapTost(tostText) {
			uni.showToast({
				title: tostText,
				icon: 'none',
				duration: 3000
			})
		},

		//初始化微信JSSDK
		async initWXH5SDK() {			
			const { appId, timestamp, nonceStr, sign } = await this.getJwxConfig()
			await this.setJwxConfig(appId, timestamp, nonceStr, sign)
			return Promise.resolve('done');
		},

		//获取JSSDK配置签名
		getJwxConfig() {
			return new Promise(resolve => {
				let url = window.location.href.split('#')[0] //当前页面域名 botms.logwirecloud.com, 相同url无需重复获取
				const { projectMini } = getApp().globalData
				const data = { args: { entryName: projectMini, url } }
				userMobileOperation('querySignature', data).then(res => { //获取签名
					if (res.data.data) {
						const { appId, timestamp, nonceStr, sign } = res.data.data
						resolve({ appId, timestamp, nonceStr, sign })
					}
				})
			})	
		},

		//配置JS-SDK
		setJwxConfig(appId, timestamp, nonceStr, signature) {
			return new Promise((resolve, reject) => {
				this.$jwx.config({ //JWX 已在main.js 中全局挂载
					debug: false, // 开启调试模式,调用的所有api的返回值会在客户端alert出来，若要查看传入的参数，可以在pc端打开，参数信息会通过log打出，仅在pc端时才会打印。
					appId: appId, // 必填，公众号的唯一标识
					timestamp: timestamp, // 必填，生成签名的时间戳
					nonceStr: nonceStr, // 必填，生成签名的随机串
					signature: signature, // 必填，签名
					jsApiList: ['scanQRCode', 'getLocation', 'openLocation','chooseImage'] // 必填，需要使用的JS接口列表
				});
				this.$jwx.ready(() => {
					this.$jwx = this.$jwx //ready 完成后供全局调用
					resolve(this.$jwx)
				});
				this.$jwx.error(err => {
					console.log('微信JSSDK实例化失败: ' + err.errMsg)
					reject(err)
				})
			})
		},


		//获取用户授权和当前位置 关于uni.getLocation(): 使用该接口需要在Manifest.json中配置相关地图Key,由于为明文故弃用
		getUserSetting() {
			this.isLocation = false
			const { serviceProvider } = getApp().globalData
			
			// #ifdef H5
			const callBack = (res) => {
				const { latitude, longitude } = res
				getApp().globalData.userLocation = { latitude, longitude } //H5转换坐标时使用
				this.getSiteName() //H5授权后手动设置一次当前位置信息
			}

			const isWxBrowser = getApp().isWxBrowser() //判断是否为微信H5
			if (isWxBrowser && this.$jwx) {
				this.$jwx.getLocation({ //H5时使用JSSDK获取经纬度,自动弹出授权对话框,真机仅弹出一次
					type: 'gcj02',
					success: (res) => {
						callBack(res)
					}
				})
			} else { //WEB浏览器
			    if(serviceProvider === 'AMap'){
					AMap.AMapGetLocation().then(res => callBack(res))
				} else {
					BMap.BMapGetLocation().then(res => callBack(res))
				}
			}
			// #endif

			// #ifdef MP
			uni.getSetting({ //小程序中判断用户是否授权位置权限
				success: (res) => {
					if (!res.authSetting['scope.userLocation']) {
						uni.authorize({
							scope: 'scope.userLocation',
							success: () => {
								this.getSiteName();
							},
							fail: () => {
								this.isLocation = true
								uni.showModal({
									title: '提示',
									content: '缺失定位信息，前往系统设置开启定位权限！',
									success: (res) => {
										if (res.confirm) {
											uni.openSetting({
												success: () => {
													this.getUserSetting()
												}
											});
										}
									}
								});
							}
						});
					} else {
						this.getSiteName();
					}
				}
			});
			// #endif	
		},

		//获取当前位置信息
		getSiteName() {			
			const { serviceProvider } = getApp().globalData
			const newMapUtil = serviceProvider === 'AMap' ? AMap : BMap
			newMapUtil.reverseGeocoder()
				.then((res) => {
					const address = res.textData.desc;
					const time = formatTime(new Date());
					const info = { ...res, address, time };
					getApp().globalData.userLocation = info;
					this.locationInfo = info
					this.isLocation = true
				})
				.catch((err) => {
					this.isLocation = true
					uni.showToast({
						title: err,
						icon: 'none',
						duration: 3000
					});
				}); 
		}
	}
};