import { uploadImg } from "../api/apiList";
module.exports = {
  data() {
    return {
      fileList: [], //文件列表
      fileDetailList: [], //文件列表, 含文件名等
      isIos: false,
    };
  },

  created() {
    // #ifdef H5
    const platform = uni.getSystemInfoSync().platform;
    if (platform === "ios") {
      // this.isIos = true
    }
    // #endif
  },
  //事件处理函数
  methods: {
    //图片上传 IOS兼容
    onUpLoad() {
      if (this.$jwx) {
        const _this = this;
        const sourceType = this.isIos ? ["album"] : ["album", "camera"]; // 可以指定来源是相册还是相机, ios指定为仅相册
        this.$jwx.chooseImage({
          sizeType: ["original", "compressed"], // 可以指定是原图还是压缩图，默认二者都有
          sourceType: sourceType,
          success: function (res) {
            _this.onConvert(res.localIds);
          },
        });
      }
    },
    async onConvert(localIds) {
      for (var i = 0; i < localIds.length; i++) {
        await this.onReadImage(localIds[i]);
      }
    },
    onReadImage(localId) {
      const _this = this;
      return new Promise((resolve, reject) => {
        _this.$jwx.getLocalImgData({
          localId: localId, // 图片的localID
          success: function (res) {
            const localData = res.localData;
            _this.fileList = _this.fileList.concat(localData);
            resolve("done!");
          },
        });
      });
    },

    //上传图片
    uploadImage(callback) {
      let { fileList } = this;
      if (!fileList.length && !this.required) return callback("");

      if (!fileList.length) {
        uni.showToast({
          title: `请选择${this.uploadTitle}`,
          icon: "error",
          duration: 3000,
        });
        return;
      }

      let images = [];
      fileList.forEach((item) => {
        const file = this.fileDetailList.find((file) => file.url === item);
        uploadImg(item, file.type).then((res) => {
          //微信小程序仅支持单文件上传,传多个文件需要反复调用本API。所以跨端的写法就是循环调用本API。
          uni.hideLoading();
          let data = JSON.parse(res).data;
          images.push(data.path);

          if (images.length === fileList.length) {
            return callback(images.join("|"));
          }
        });
      });
    },
	
	//上传图片
	uploadFile(callback) {
	  let { fileList } = this;
	  if (!fileList.length && !this.required) return callback("");
	
	  if (!fileList.length) {
	    uni.showToast({
	      title: `请选择${this.uploadTitle}`,
	      icon: "error",
	      duration: 3000,
	    });
	    return;
	  }
	
	  let images = [];
	  fileList.forEach((item) => {
	    const file = this.fileDetailList.find((file) => file.url === item);
	    uploadImg(item, "file").then((res) => {
	      //微信小程序仅支持单文件上传,传多个文件需要反复调用本API。所以跨端的写法就是循环调用本API。
	      uni.hideLoading();
	      let data = JSON.parse(res).data;
	      images.push(data.path);
	
	      if (images.length === fileList.length) {
	        return callback(images.join("|"));
	      }
	    });
	  });
	},
	

    // 上传文件回调
    uploadAfterRead(info) {
      let { file } = info;
      const newFile = file.map((item) => item.url);
      this.fileList = [...this.fileList, ...newFile];
      this.fileDetailList = [...this.fileDetailList, ...file];
	  this.$emit("uploadFileDetail",this.fileList)
    },

    // 预览图片回调
    previewImage(e) {
      let { index } = e.currentTarget.dataset;
      uni.previewImage({
        current: index,
        urls: this.fileList,
      });
    },

    // 删除当前选中文件
    deleteFile(index) {
      uni.showModal({
        title: "删除提示",
        content: "是否确认删除？",
        success: (res) => {
          if (res.confirm) {
            this.fileList = this.fileList.filter((item, idx) => idx !== index);
            this.fileDetailList = this.fileDetailList.filter(
              (item, idx) => idx !== index
            );
			this.$emit("uploadFileDetail",this.fileList)
          } else if (res.cancel) {
          }
        },
      });
    },
	
	resetFile(){
		this.fileList = [];
		this.fileDetailList = [];
	}
  },
};
