/*
 BASEURL: 说明
  1. 本地开发调试： 小程序修改该url即可；H5则无需关心，H5修改manifest.json中h5相关Proxy配置即可
  2. 打包生产模式： 小程序切换url； H5切换ENV_MODEL
 */
let BASEURL = {
	// url: "http://localhost:8083", //开发
	// url: "http://122.112.220.204:8089", //开发
	url: "https://stms.bjzc-scs.com", //生产
};

//当使用多域名代理服务时生效，用于统一添加API前缀以区分服务代理地址。本地开发H5注意修改manifest.json中Proxy代理规则
const APIPrefix = ""; //TMS项目
// const APIPrefix = '/testMaster' //体验版测试环境: Test Master
// const APIPrefix = '/tmsdemo' //正式版环境: TMS Demo
// const APIPrefix = '/sandtable' //沙盘演示项目
// const APIPrefix = '/tmsca' //三方物流项目

//H5打包环境区分：打包时手动切换，添加新的环境变量时，注意同步修改APP.vue 和loginBehavior.js中环境判断逻辑
const ENV_MODEL = {
	// model: 'UAT', //测试环境
	model: "PROD", //生产环境
};

//用于数据请求时替换所有API接口的{mini}
let MINI = {
	h5Prod: "working-weixin-pda", //生产项目名
	h5Uat: "working-weixin-pda", //测试项目名
	h5Dev: "working-weixin-pda", //开发项目名
	web: "working-weixin-pda",
	// h5Prod: "working-weixin", //生产项目名
	// h5Uat: "working-weixin", //测试项目名
	// h5Dev: "working-weixin", //开发项目名
	// web: "working-weixin",
};

//仅用于H5换取用户授权Code使用，后端可用此Code换取用户OpenId等信息
let APP_ID = {
	h5Prod: "ww5b68e5106ed852c5", //生产公众号appid
	h5Uat: "ww5b68e5106ed852c5", //测试公众号appid
	h5Dev: "ww5b68e5106ed852c5", //开发公众号appid
};

const CORP_ID = "ww5b68e5106ed852c5";
const AGENT_ID = "1000005";
const JS_API_LIST = [
	"checkJsApi",
	"getContext",
	"selectExternalContact",
	"scanQRCode",
	"getCurExternalChat",
	"sendChatMessage",
	"launchMiniprogram",
	"getCurExternalContact",
	"getLocation",
	"getCurExternalChat",
];
const TokenPrefix = "working-weixin-pda"; // Token && XSRFToken 前缀, 避免运行于WEB端时，打开多端Token覆盖、混淆问题
// const TokenPrefix = "working-weixin"; // Token && XSRFToken 前缀, 避免运行于WEB端时，打开多端Token覆盖、混淆问题
module.exports = {
	BASEURL,
	MINI,
	APP_ID,
	ENV_MODEL,
	TokenPrefix,
	APIPrefix,
	CORP_ID,
	AGENT_ID,
	JS_API_LIST,
};