//默认时间转换
const formatTime = (date, type) => {
  const year = date.getFullYear()
  const month = date.getMonth() + 1
  const day = date.getDate()
  const hour = date.getHours()
  const minute = date.getMinutes()
  const second = date.getSeconds()
  if(type === 'D'){ //只传递年月日
	return `${[year, month, day].map(formatNumber).join('-')}T00:00:00+08:00`
  }else{
	return `${[year, month, day].map(formatNumber).join('-')}T${[hour, minute, second].map(formatNumber).join(':')}+08:00` 
  }
}

const formatNumber = n => {
  n = n.toString()
  return n[1] ? n : `0${n}`
}
//获取图片base
function getImgBase64(filePaths) {
  let pictures_str = ''
  filePaths.forEach(function (filePath) {
    var suffixs = filePath.split(".")
    //文件名后缀
    var suffix = suffixs[suffixs.length - 1]
    var fs = wx.getFileSystemManager()
    var filedata = ''
    if (filePath.indexOf("data:image") != -1) {
      filedata = filePath
    } else {
      filedata = "data:image/" + suffix + ";base64," + fs.readFileSync(filePath, 'base64')
    }
    if (pictures_str == '') {
      pictures_str = filedata
    } else {
      pictures_str = pictures_str + '|' + filedata
    }
  })
  return pictures_str
}
//格林威治时间转换
const formatGMT = (time, type) => { // time 为UTC时间格式 2022-06-30T16:00:00Z
  if(!time) return
  const timestamp = new Date(time).getTime() //转本地时间
  let date = formatTime(new Date(timestamp))
  if (type === 'D') { //只显示年月日
    date = date.substring(0, 10)
  } else if(type === 'H'){ //只显示时分秒
	 date = date.substring(0, 19).split('T')[1]
  } else if(type === 'M'){ //只显示小时分钟
	 date = date.substring(0, 16).split('T')[1]
  } else {
    date = date.substring(0, 19).replace('T', ' ')
  }
  return date
}

function deepCopy(obj) {
  if (obj instanceof Object) {
    const newObj = {};
    if (Array.isArray(obj)) {
      const arr = [];
      obj.forEach(item => {
        arr.push(deepCopy(item));
      });
      return arr;
    } else {
      for (const key in obj) {
        const value = obj[key];
        if (typeof value === 'function') {
          newObj[key] = value.bind(newObj);
        } else if (typeof value === 'object') {
          if (Array.isArray(value)) {
            newObj[key] = [];
            value.forEach(item => {
              newObj[key].push(deepCopy(item));
            });
          } else {
            newObj[key] = deepCopy(value);
          }
        } else {
          newObj[key] = value;
        }
      }
    }
    return newObj;
  } else {
    return obj;
  }
}
const dateTransformYMDhms = (date)=>{
  const Y = date.getFullYear()
  const M = date.getMonth() + 1
  const D = date.getDate()
  const h = date.getHours()
  const m = date.getMinutes()
  const s = date.getSeconds()
  return {Y,M,D,h,m,s}
}

module.exports = {
  formatTime,
  getImgBase64,
  formatGMT,
  deepCopy,
  dateTransformYMDhms
}