import Request from "./request";
import uploadFile from "./uploadFile";
import downloadFile from "./downloadFile";
import {
	BASEURL,
	TokenPrefix,
	APIPrefix,
	MINI
} from "../publicConfig/config";



export function searchBossCard(data) {
	return Request(`/api/entry/{mini}/m-action/biz.tm.OrderRelease.service.searchBossCard`, data)
}
export function searchOrderEvent(data) {
	return Request(`/api/entry/{mini}/m-action/biz.tm.OrderRelease.service.searchOrderEvent`, data)
}
export function searchOrderEventDetail(data) {
	return Request(`/api/entry/{mini}/m-action/biz.tm.OrderRelease.service.searchOrderEventDetail`, data)
}

export function BindCompany(data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.om.LogisticsOrder.service.bindCompany`,
		data
	);
}

export function selectDailyReport(data) {
	return Request(`/api/entry/{mini}/m-action/biz.zcgyl.DailyReport.service.selectDailyReport`, data)
}
export function dailyReportSave(data) {
	return Request(`/api/entry/{mini}/m-action/biz.zcgyl.DailyReport.service.auxVoSave`, data)
}
export function selectReporter(data) {
	return Request(`/api/entry/{mini}/m-action/biz.zcgyl.DailyReport.service.selectReporter`, data)
}

export function selectStaffByUsername(data) {
	return Request(`/api/entry/{mini}/m-action/biz.zcgyl.DailyReport.service.selectStaffByUsername`, data)
}



// 登录接口
// mimi: 项目名：biz-carrier-wxapp  LOGIN_ACTION: loginByUserInfo
export function userLogin(loginAction, loginCode, data) {
	return Request(
		`/api/auth/app-login/{mini}/${loginAction}?weixin_config_key={mini}&code=${loginCode}`,
		data
	);
}
// 用户中心操作&&初始化JS-SDK  action 说明： 退出登录：logout  获取用户信息: getUserInfo 修改密码：changePassword 初始化SDK: querySignature
export function userMobileOperation(action, data) {
	if (action === "logout") {
		//退出登录
		return Request(`/logout`, data, "GET"); // data: {openId, entryName}
	} else {
		return Request(`/api/entry/{mini}/m-action/${action}`, data);
	}
}
//获取地图key
export function getMap() {
	return Request(`/api/query/*/action/getMap`);
}
//获取地图颜色
export function getMapColor(data) {
	return Request(`/api/query/biz.md.Truck/action/service-getMapColor`, data);
}
// 上传图片
export function uploadImg(data, fileType = "image") {
	return uploadFile("/api/doc/upload", data, fileType);
}
// 下载图片
export function downloadImg(data) {
	return downloadFile("/api/doc/download", data);
}

//查询运单列表
export function findShipmentOrders(data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.tm.Shipment.tm_shipment_m_carrier.paging`,
		data
	);
}
//查询运单详情
export function findShipmentDetail(data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.tm.Shipment.tm_shipment_qw_carrier_page.get`,
		data
	);
}
//查询运单途径站点
export function findShipmentStops(data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.tm.ShipmentStop.tm_shipmentstop_m_carrier.paging`,
		data
	);
}

// 查询货量明细
// OM模式
export function OMOrderDetail(data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.tm.OrderMovementLine.tm_ordermovementline_m_search.paging`,
		data
	);
}
// OR模式
export function OROrderDetail(data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.tm.OrderLine.tm_orderline_m_search.paging`,
		data
	);
}

//查询中转地址
export function searchTransferAddress(data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.md.TransferAddress.md_transferaddress_m_search.paging`,
		data
	);
}

//查询准驾车型
export function queryDrivingType() {
	return Request(`/api/query/choice.md.QuasiDrivingType/action/auto_choice`);
}
//查询车辆车型
export function queryTruckType(data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.md.TruckMode.md_truckmode_m_search.paging`,
		data
	);
}

//查询司机列表
export function searchDriverList(data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.md.Driver.md_driver_m_search.paging`,
		data
	);
}
//查询车辆列表
export function searchTruckList(data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.md.Truck.md_truck_m_search.paging`,
		data
	);
}
//查询道口
export function searchDockList(data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.md.Dock.md_dock_m_search.paging`,
		data
	);
}

//查询道口可预约时间
export function searchDockTime(data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.md.DockTimeTable.md_docktimetable_m_search.paging`,
		data
	);
}

//中转换、卸货 分配车辆司机
//action说明： 中转换车：transferAndChangeTruck 中转卸货：transferAndUnload 分配车辆司机: assign
export function reportInfo(action, data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.tm.Shipment.operation.${action}`,
		data
	);
}

//司机、车辆注册

//司机、车辆详情
//action说明： 司机：Driver 车辆：Truck
export function searchDriverTruckDetail(action, data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.md.${action}.md_${action.toLocaleLowerCase()}_m_page.get`,
		data
	);
}

//预约站点
export function loadDockBooking(data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.tm.ShipmentStop.operation.loadDockBooking`,
		data
	);
}

//取消站点预约
export function dockBookingCancel(data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.tm.ShipmentStop.operation.dockBookingCancel`,
		data
	);
}

//调度确认、取消确认 operationType: approve approveCancel
export function shipmentDispatch(operationType, data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.tm.Shipment.operation.${operationType}`,
		data
	);
}

//签收  模式：OM：OrderMovement  OR: SimpleOrder
export function signFor(shipMode, data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.tm.${shipMode}.operation.receive`,
		data
	);
}

//订单列表 OM/OR/MASS模式
export function ordermovementOM(data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.tm.OrderMovement.tm_ordermovement_m_search.paging`,
		data
	);
}

export function ordermovementOR(data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.tm.SimpleOrder.tm_simpleorder_m_search.paging`,
		data
	);
}

export function ordermovementMASS(data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.tm.MassShipment.tm_massshipment_m_page.get`,
		data
	);
}

//修改人员详情
export function UpdateDriverInfo(data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.md.Driver.service.updateInfo`,
		data
	);
}

//修改车辆详情
export function UpdateTruckInfo(data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.md.Truck.service.updateInfo`,
		data
	);
}

//获取大宗订单
export function getMassOrderList(data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.tm.MassOrderCarrier.tm_massordercarrier_m_search.paging`,
		data
	);
}

//获取大宗订单已分配车辆
export function getMassOrderTruckList(data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.tm.MassOrderTruck.tm_massordertruck_m_search.paging`,
		data
	);
}

//大宗订单车辆分配 assignType:  分配单辆车：assignTruck  分配多量车：assignTrucks
export function massAssignTruck(data, assignType) {
	return Request(
		`/api/entry/{mini}/m-action/biz.tm.MassOrderCarrier.${assignType}`,
		data
	);
}

//更新大宗订单配车
export function updateMassAssignTruck(data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.tm.MassOrderTruck.service.updateOrderTrucks`,
		data
	);
}

//更新大宗订单配车
export function GetSignUrl(data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.tm.OrderRelease.operation.electronicVisa`,
		data
	);
}

// 验证码发送
export function SendMessage(data) {
	return Request(`/handler/sendMessage`, data);
}

// 订单轨迹
export function findShipmentLbs(data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.tm.Shipment.service.lbs`,
		data
	);
}

//获取公司列表
export function GetCompanyList(data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.md.Company.md_company_m_search.paging`,
		data
	);
}

//获取订单

export function OrderQuery(data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.tm.StandardLinesOrder1.tm_standardlinesorder1_zc_parts_search1.paging`,
		data
	);
}

export function GetOrderDetailInfo(data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.tm.StandardLinesOrder1.tm_standardlinesorder1_zc_parts_new_page1.bizObjectGet`,
		data
	);
}



export function GetImportTemplate(data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.om.LogisticsOrder.service.getImportTemplate`,
		data
	);
}

export function TaskQuery(data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.adapter.AdapterInputTask.adapter_adapterinputtask_m_search.paging`,
		data
	);
}

export function SellQuery(data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.bm.SellSettlement.bm_sellsettlement_search.paging`,
		data
	);
}

export function DownloadFailData(data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.om.LogisticsOrder.service.downloadFailData`,
		data
	);
}

export function AdaptImport(data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.om.LogisticsOrder.service.adaptImport`,
		data
	);
}

export function SellConfirm(data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.bm.SellSettlement.operation.confirm`,
		data
	);
}

export function DownloadSettlement(data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.bm.SellSettlement.operation.downloadSettlement`,
		data
	);
}

export function getTicketByType(data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.tm.OrderRelease.service.getTicketByType`,
		data
	);
}

export function GetBindCompanyResult(data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.om.LogisticsOrder.service.getBindCompanyResult`,
		data
	);
}

export function GetBindCompanyInfo(data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.om.LogisticsOrder.service.getBindCompanyInfo`,
		data
	);
}


export function queryOriginalAddress(data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.md.Address.md_address_m_search.paging`,
		data
	);
}

export function queryDestinationAddress(data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.md.Address.md_address_search.paging`,
		data
	);
}

export function queryObject(data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.md.Project.md_project_search.paging`,

		data
	);
}

export function queryTransportMode(data) {
	return Request(`/api/query/choice.md.TransportMode/action/auto_choice`);
}

export function queryTransportProduct(data) {
	return Request(`/api/query/choice.om.TransportProduct/action/auto_choice`);
}

export function orderInsert(data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.tm.StandardLinesOrder1.bizSave`,
		data
	);
}

export function wxSendMessage(data) {
	data.aux.entryName = MINI.h5Uat;
	return Request(
		`/api/entry/{mini}/m-action/biz.om.LogisticsOrder.service.sendMessage`,
		data
	);
}

export function queryThing(data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.md.Thing.md_thing_search.paging`,

		data
	);
}

//type说明： 上报类型：TransitType 费用类型：DriverCostType 订单上报类型：OrderEventType
export function getOptionEnum(type) {
	return Request(`/api/query/choice.om.${type}/action/auto_choice`);
}

export function bindWeComGroup(data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.om.LogisticsOrder.service.bindWeComGroup`,
		data
	);
}

export function GetShipment(data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.tm.StandardLinesOrder1.service.getShipmentData`,
		data
	);
}

export function GetOrderRelease(data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.tm.StandardLinesOrder1.operation.getOrderRelease`,
		data
	);
}

export function OrderReleaseEvent(data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.tm.OrderEvent.tm_orderevent_m_search.paging`,
		data
	);
}

//查询运单
export function waybillList(data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.tm.Shipment.tm_shipment_m_search.paging`,
		data
	);
}

//异常信息
export function getAbnormalEvent(data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.tm.AbnormalEvent.tm_abnormalevent_page.get`,
		data
	);
}

//发生地址
export function getLocation(data) {
	return Request(`/api/query/biz.md.Location.md_location_auto/auto`, data);
}

//发货地址
export function getOriginalAddress(data) {
	return Request(
		`/api/query/biz.md.Address.md_originaladdress_auto/auto`,
		data
	);
}

//新送货地址
export function newDestinationAddress(data) {
	return Request(
		`/api/query/biz.md.Address.md_destinationaddress_auto/auto`,
		data
	);
}

//获取项目名
export function getProject(data) {
	return Request(`/api/query/biz.md.Address.md_project_auto/auto`, data);
}

//获取异常类型
export function getExceptionType(data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.md.TransportExceptionType.md_transportexceptiontype_search.paging`,
		data
	);
}

//获取节点信息
export function getNodeType(data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.tm.ShipmentEvent.tm_shipmentevent_m_search.paging`,
		data
	);
}

//提交信息
export function createAbnormal(data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.tm.AbnormalEvent.service.createAbnormalEvent`,
		data
	);
}

//获取导入下拉规则
export function getImportRule(data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.tm.ShipmentEvent.service.getImportTemplate`,
		data
	);
}
//获取看板数据
export function getStatisticalDashboard(data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.tm.Shipment.service.getStatisticalDashboard`,
		data
	);
}

//获取异常列表
export function getAbnormalEventList(data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.tm.AbnormalEvent.tm_abnormalevent_m_search.paging`,
		data
	);
}

//获取异常详情
export function getAbnormalDetail(data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.tm.AbnormalEvent.tm_abnormalevent_m_page.get`,
		data
	);
}

//获取账单
export function getSellSettlement(data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.bm.SellSettlement.bm_sellsettlement_search.paging`,
		data
	);
}

//在途导入
export function shipmentAdaptImport(data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.tm.ShipmentEvent.service.adaptImport`,
		data
	);
}

//获取特殊指令
export function getOrderTaskByShipment(data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.tm.OrderTask.service.getOrderTaskByShipment`,
		data
	);
}

//获取
export function getImportLog(data) {
	return Request(
		`/api/entry/{mini}/m-action/biz.adapter.AdapterInputTask.adapter_adapterinputtask_m_search.paging`,
		data
	);
}

//获取订单状态枚举
export function getShipmentStatus(data) {
	return Request(`/api/query/choice.tm.ShipmentStatus/action/auto_choice`);
}