import Vue from 'vue'
import Router from 'vue-router'
import Index from '../../databoard/index.vue'
import IndexSale from '../../databoard/index_sale'
import ArBar from "../../databoard/components/chart/ar-bar.vue";
import ArCompanyBar from "../../databoard/components/chart/ar-company-bar.vue";
import ArMonthlyBar from "../../databoard/components/chart/ar-monthly-bar.vue";
import ArCompanyMonthlyBar from "../../databoard/components/chart/ar-company-monthly-bar.vue";
import ArMonthlyCompanyBar from "../../databoard/components/chart/ar-monthly-company-bar.vue";
import TurnoverDetail from "../../databoard/databoard/turnover-detail.vue";
import OrderProportion from "../../databoard/databoard/order-proportion.vue";
import LostAddCustomer from "../../databoard/databoard/lost-add-customer.vue";
import TargetAchievement from "../../databoard/databoard/target-achievement.vue";
import DepartmentShipment from "../../databoard/databoard/department-shipment.vue";
import ElementUI from 'element-ui';
import 'element-ui/lib/theme-chalk/index.css';
import SafeQuality from "../../databoard/databoard/safe-quality";


Vue.use(Router)
Vue.use(ElementUI)

export default new Router({
  routes: [
    {
      path: '/',
      redirect: '/index'
    },
    {
      path: '/index',
      name: 'index',
      component: Index
    },
    {
      path: '/index_sale',
      name: 'index_sale',
      component: IndexSale
    },
    {
      path: '/ar_bar',
      name: 'arBar',
      component: ArBar,
      children: [
        {
          path: '/ar_bar',
          redirect: '/ar_bar/company'
        },
        {
          path: '/ar_bar/company',
          name: 'arCompanyBar',
          component: ArCompanyBar
        },
        {
          path: '/ar_bar/company/monthly',
          name: 'arCompanyMonthlyBar',
          component: ArCompanyMonthlyBar
        },
        {
          path: '/ar_bar/monthly',
          name: 'arMonthlyBar',
          component: ArMonthlyBar
        },
        {
          path: '/ar_bar/monthly/company',
          name: 'arMonthlyCompanyBar',
          component: ArMonthlyCompanyBar
        }
      ]
    },
    {
      path: '/turnover-detail',
      name: 'turnoverDetail',
      component: TurnoverDetail
    },
    {
      path: '/order-proportion',
      name: 'OrderProportion',
      component: OrderProportion
    },
    {
      path: '/lost-add-customer',
      name: 'lostAddCustomer',
      component: LostAddCustomer
    },
    {
      path: '/target-achievement',
      name: 'TargetAchievement',
      component: TargetAchievement
    },
    {
      path: '/department-shipment',
      name: 'DepartmentShipment',
      component: DepartmentShipment
    },
    {
      path: '/safe-quality',
      name: 'safeQuality',
      component: SafeQuality
    }
  ]
})
