import fetch from './fetch'

//获取验证码配置
export const captchaConfig = () => fetch('/auth/required-captcha?type=web', {});

//获取是否忘记密码配置
export const passwordRecover = () => fetch('/auth/get-authentication-config', {}, 'POST');

//获取验证码图片
export const captcha = () => fetch('/auth/get-captcha', {}, 'POST');

//登录
export const userLogin = (username, pass, captchaSign, verificationcode, captchaTimestamp) => fetch('/api/auth/login', {
  username: username,
  password: pass,
  captcha: {
    sign: captchaSign,
    captcha: verificationcode,
    timestamp: captchaTimestamp
  }
}, 'POST');

//首页营业额率值 -汇总
export const getBusinessConditionDatas = (cur_day) => fetch('/api/query/*/action/get_business_condition_datas', {
  aux: {
    cur_day: cur_day
  }
}, 'POST');

//明细页营业额汇月 -汇总
export const getBusinessConditionDataByMonth = (cur_day) => fetch('/api/query/*/action/get_business_condition_datas_by_month', {
  aux: {
    cur_day: cur_day
  }
}, 'POST');


//明细页营业额汇年 -汇总
export const getBusinessConditionDatasByYear = (cur_day) => fetch('/api/query/*/action/get_business_condition_datas_by_year', {
  aux: {
    cur_day: cur_day
  }
}, 'POST');

//明细页营业额汇年 -同期对比
export const getBusinessConditionDatasByYoy = (cur_day) => fetch('/api/query/*/action/get_business_condition_datas_by_yoy', {
    aux: {
        cur_day: cur_day
    }
}, 'POST');


// 应收账款汇总
export const arSummaryBar = () => fetch("/api/query/dash_board/action/get_ar_summary_bar", {}, "POST")
// 应收账款列表
export const arCompanyList = () => fetch("/api/query/dash_board/action/get_ar_company_list", {}, "POST")
// 应收账款（结算单位）
export const arCompanyBar = () => fetch("/api/query/dash_board/action/get_ar_company_bar", {}, "POST")
// 应收账款（开票月份）
export const arMonthlyBar = () => fetch("/api/query/dash_board/action/get_ar_monthly_bar", {}, "POST")
// 结算单位 应收账款（开票月份）
export const arCompanyMonthlyBar = (company) => fetch("/api/query/dash_board/action/get_ar_company_monthly_bar", {aux: {company: company}}, "POST")
// 开票月份 应收账款（结算单位）
export const arMonthlyCompanyBar = (month) => fetch("/api/query/dash_board/action/get_ar_monthly_company_bar", {aux: {month: month}}, "POST")
//明细页营业额汇月 -汇总
export const getAllTypeBusinessConditionDatas = (cur_day) => fetch('/api/query/*/action/get_all_type_business_condition_datas', {
  aux: {
    cur_day: cur_day
  }
}, 'POST');


//明细页各种运输类型营业额明细
export const getAllTypeBusinessConditionDetailByDay = (cur_day) => fetch('/api/query/*/action/get_all_type_business_condition_detail_by_day', {
  aux: {
    cur_day: cur_day
  }
}, 'POST');

//明细页各种运输类型营业额汇总-月维度
export const getAllTypeBusinessConditionDatasByMonth = (cur_day) => fetch('/api/query/*/action/get_all_type_business_condition_datas_by_month', {
  aux: {
    cur_day: cur_day
  }
}, 'POST');

//明细页各种运输类型营业额汇总-年维度
export const getAllTypeBusinessConditionDatasByYear = (cur_day) => fetch('/api/query/*/action/get_all_type_business_condition_datas_by_year', {
  aux: {
    cur_day: cur_day
  }
}, 'POST');

//明细页各种运输类型营业额明细-月维度
export const getAllTypeBusinessConditionDetailByMonth = (cur_day) => fetch('/api/query/*/action/get_all_type_business_condition_detail_by_month', {
  aux: {
    cur_day: cur_day
  }
}, 'POST');

//明细页各种运输类型营业额明细-年维度
export const getAllTypeBusinessConditionDetailByYear = (cur_day) => fetch('/api/query/*/action/get_all_type_business_condition_detail_by_year', {
  aux: {
    cur_day: cur_day
  }
}, 'POST');


export const transportTypeOrderFinishPie = (date) => fetch("/api/query/dash_board/action/get_order_finish_data_by_transport_type_day", {aux: {"cur_day": date}}, "POST")
export const customerOrderFinishPie = (date) => fetch("/api/query/dash_board/action/get_order_finish_data_by_customer_day", {aux: {"cur_day": date}}, "POST")
export const getOrderFinishDataByCondition = (aux) => fetch("/api/query/*/action/get_order_finish_data_by_condition", {aux: aux}, "POST")
export const getOrderWeightAndProportionList = (aux) => fetch("/api/query/dash_board/action/get_order_weight_and_proportion_list", {aux: aux}, "POST")
export const getTargetOrderDataByCondition = (aux) => fetch("/api/query/*/action/get_target_order_data_by_condition", {aux: aux}, "POST")

//流失客户 & 新增客户
export const getOrderLoseAddCustomer = (cur_day) => fetch('/api/query/*/action/get_order_loss_add_customer', {
  aux: {
    cur_day: cur_day
  }
}, 'POST');

//流失客户 & 新增客户-明细
export const getOrderAddCustomerDetail = (cur_day, type,cur_page) => fetch('/api/query/*/action/get_order_add_customer_detail', {
  aux: {
    cur_day: cur_day,
    type: type,
    cur_page:cur_page
  }
}, 'POST');

//当日订单量，当时完成量 余量
export const getOrderBusinessConditionData = (cur_day, type) => fetch('/api/query/*/action/get_order_business_condition_data', {
  aux: {
    cur_day: cur_day
  }
}, 'POST');


