import fetch from './fetch'

//获取验证码配置
export const captchaConfig = () => fetch('/auth/required-captcha?type=web', {});

//获取是否忘记密码配置
export const passwordRecover = () => fetch('/auth/get-authentication-config', {}, 'POST');

//获取验证码图片
export const captcha = () => fetch('/auth/get-captcha', {}, 'POST');

//登录
export const userLogin = (username, pass, captchaSign, verificationcode, captchaTimestamp) => fetch('/api/auth/login', {
  username: username,
  password: pass,
  captcha: {
    sign: captchaSign,
    captcha: verificationcode,
    timestamp: captchaTimestamp
  }
}, 'POST');

//首页营业额率值 -汇总
export const getBusinessConditionDatas = (cur_day) => fetch('/api/query/*/action/get_business_condition_datas', {
  aux: {
    cur_day: cur_day
  }
}, 'POST');

//明细页营业额汇月 -汇总
export const getBusinessConditionDataByMonth = (cur_day) => fetch('/api/query/*/action/get_business_condition_datas_by_month', {
  aux: {
    cur_day: cur_dayS
  }
}, 'POST');


//明细页营业额汇年 -汇总
export const getBusinessConditionDatasByYear = (cur_day) => fetch('/api/query/*/action/get_business_condition_datas_by_year', {
  aux: {
    cur_day: cur_dayS
  }
}, 'POST');









// 应收账款汇总
export const arSummaryBar = () => fetch("/api/query/dash_board/action/get_ar_summary_bar", {}, "POST")
// 应收账款列表
export const arCompanyList = () => fetch("/api/query/dash_board/action/get_ar_company_list", {}, "POST")
// 应收账款（结算单位）
export const arCompanyBar = () => fetch("/api/query/dash_board/action/get_ar_company_bar", {}, "POST")
// 应收账款（开票月份）
export const arMonthlyBar = () => fetch("/api/query/dash_board/action/get_ar_monthly_bar", {}, "POST")
// 结算单位 应收账款（开票月份）
export const arCompanyMonthlyBar = (company) => fetch("/api/query/dash_board/action/get_ar_company_monthly_bar", {aux: {company: company}}, "POST")
// 开票月份 应收账款（结算单位）
export const arMonthlyCompanyBar = (month) => fetch("/api/query/dash_board/action/get_ar_monthly_company_bar", {aux: {month: month}}, "POST")
