import {
  getOrderAddCustomerDetail
} from "./../../../api/apiList";
import {conver_amont} from "./../../../utils/numUtil";
import moment from 'moment'
//天维度数据转换
export const getAllDatas = async function (cur_day, type,cur_page) {
  let pageData = {};
  let totle = 0;
  let curPage = 1;
  let res = await getOrderAddCustomerDetail(cur_day, type,cur_page);
  let lostAdd = resultProcess(res.data.data);
  pageData.leftData = lostAdd.slice(0,20);
  pageData.rightData = lostAdd.slice(20,40);
  pageData.curPage = res.data.cur_page;
  pageData.total = res.data.total;
  return pageData;
};

/**
 * 后端接口数据处理
 * @param detailList
 * @returns {Promise<void>}
 */
export const resultProcess = function (detailList) {
  let lostAddDataList = new Array();
  for (let key in detailList) {
    let resData = detailList[key];
    let lostAdd = adapterLostAdd(resData)
    lostAddDataList.push(lostAdd)
  }
  return lostAddDataList
}

/**
 * 数据处理
 * @param data
 * @returns
 */
export const adapterLostAdd = function (data) {
  let lostAddData = {};
  lostAddData['title'] = data.entrust_agency_name;
  let lostAddDataCol = new Array();
  lostAddDataCol[0] = adapterLostAddCol("订单量(万吨) ", conver_amont(data.unit_weight), "red")
  lostAddDataCol[1] = adapterLostAddCol("订单件数", data.qty, "#eaa749")
  lostAddDataCol[2] = adapterLostAddCol("营业额(万元)", conver_amont(data.sell_settle_amount), "#49eb29")
  lostAddData['column'] = lostAddDataCol;
  return lostAddData;
}
export const adapterLostAddCol = function (key, val, styleColor) {
  let lostAddDataCol = new Object();
  lostAddDataCol.key = key;
  lostAddDataCol.value = val;
  lostAddDataCol.valStyle = {"color": styleColor}
  return lostAddDataCol;
}

