import { getTargetOrderDataByCondition} from '../../../api/apiList';
import {calc_hb_str, calc_zb_str, conver_amont} from "../../../utils/numUtil";
import mockData from "../mockData/target-achievement.json";


export const getData = async (aux,callback) => {
  let resList = new Array();
  await getTargetOrderDataByCondition(aux).then(function (res) {
    resList = res.data;
  });
  callback(resList);
  return resList
}

export const getTargetOrderDataByConditionCount = async (aux,callback) => {
  let resData;
  await getTargetOrderDataByCondition(aux).then(function (res) {
    resData = dataFormatter(res.data);
  });
  callback(resData);
  return resData
}

function generateData(count, res) {
  res.push({
    title: "吨位(万吨)",
    actualValue: conver_amont(count.unit_weight),
    targetValue: conver_amont(count.target_unit_weight),
  })
  res.push({
    title: "营业额(万元)",
    actualValue: conver_amont(count.sell_settle_amount),
    targetValue: conver_amont(count.target_sell_settle_amount),
  })
  res.push({
    title: "净利润(万元)",
    actualValue: conver_amont(count.gross_profit_amount),
    targetValue: conver_amont(count.target_gross_profit_amount),
  })
}

function dataFormatter(data){
  let res = [];
  for (let i = 0; i < data.length; i++) {
    if (data[i].group_name === "总计"){
      generateData(data[i], res);
      break;
    }
  }
  //mock数据，接口没好的时候用的
  if (res.length === 0){
    let count = mockData.count;
    generateData(count, res);
  }
  return res;
}

