import {
  getBusinessConditionDatas,
  getAllTypeBusinessConditionDatas,
  getAllTypeBusinessConditionDetailByDay,
  getBusinessConditionDataByMonth,
  getAllTypeBusinessConditionDatasByMonth,
  getAllTypeBusinessConditionDetailByMonth,
  getBusinessConditionDatasByYear,
  getAllTypeBusinessConditionDatasByYear,
  getAllTypeBusinessConditionDetailByYear
} from "../../api/apiList";
import {calc_hb_str, calc_tb_str, conver_amont} from "../../utils/numUtil";
import moment from 'moment'
//天维度数据转换
export const getTrunOver = async function (dimension, type, cur_day) {
  let pageData = new Object();
  pageData.head = await getHead(dimension, type, cur_day)
  pageData.detail = await getDetail(dimension, type, cur_day)
  return pageData;
};

/**
 * @param cur_day
 */
export const getHead = async function (dimension, type, cur_day) {
  let typeName = new Object({"yye": "营业额", "cb": "成本", "ml": "毛利"});
  let pageName = typeName[type]
  let truck = "汽运" + pageName;
  let ship = "水运" + pageName;
  let tran = "铁运" + pageName;
  let headData = new Object();
  let transportData;
  let res = await reqDaySumData(dimension, cur_day);
  headData[pageName] = adapterSumData(dimension, type, res);
  transportData = await reqDayTransportData(dimension, cur_day)
  headData[truck] = initSumDataDay();
  headData[ship] = initSumDataDay();
  headData[tran] = initSumDataDay();
  if (transportData[10]) {
    headData[truck] = adapterSumData(dimension, type, transportData[10]);
  }
  if (transportData[30]) {
    headData[ship] = adapterSumData(dimension, type, transportData[30]);
  }
  if (transportData[20]) {
    headData[tran] = adapterSumData(dimension, type, transportData[20]);
  }
  return headData;
};
//获取折线图明细
export const getDetail = async function (dimension, type, cur_day) {
  let res;
  if (dimension == 'day') {
    res = await getAllTypeBusinessConditionDetailByDay(moment(cur_day).format('YYYY-MM'));
  }
  if (dimension == 'month') {
    res = await getAllTypeBusinessConditionDetailByMonth(cur_day)
  }
  if (dimension == 'year') {
    res = await getAllTypeBusinessConditionDetailByYear(cur_day)
  }
  let data = res.data
  return adapterDetailData(dimension, type, data)
};

//获取全部汇总数据
export const reqDaySumData = async function (dimension, cur_day) {
  let res;
  if (dimension == 'day') {
    res = await getBusinessConditionDatas(cur_day);
  }
  if (dimension == 'month') {
    res = await getBusinessConditionDataByMonth(cur_day);
  }
  if (dimension == 'year') {
    res = await getBusinessConditionDatasByYear(cur_day);
  }
  let data = res.data
  return data;
}

//获取每个运输方式汇总数据
export const reqDayTransportData = async function (dimension, cur_day) {
  let res;
  if (dimension == 'day') {
    res = await getAllTypeBusinessConditionDatas(cur_day);
  }
  if (dimension == 'month') {
    res = await getAllTypeBusinessConditionDatasByMonth(cur_day);
  }
  if (dimension == 'year') {
    res = await getAllTypeBusinessConditionDatasByYear(cur_day);
  }
  let data = res.data
  return data;
}


//获取明细数据数据
export const reqTransportDetailDayData = async function (cur_day) {
  let res = await getAllTypeBusinessConditionDetailByDay(moment(cur_day).format('YYYY-MM'));
  let data = res.data
  return data;
}


/**
 * 数据匹配
 * @param type
 * @param data
 */
export const adapterSumData = function (dimension, type, data) {
  let res;
  if (dimension == 'day') {
    res = adapterSumDataDay(type, data);
  }
  if (dimension == 'month') {
    res = adapterSumDataMonth(type, data);
  }
  if (dimension == 'year') {
    res = adapterSumDataYear(type, data);
  }
  return res;
}


/**
 *日维度汇总
 * @param type yye:营业额、cb:成本、ml:毛利
 * @param data
 */
export const adapterSumDataDay = function (type, data) {
  let turnOver = initSumDataDay();
  let hb = new Array()
  if (type == 'yye') {
    turnOver.title = '营业额'
    turnOver.amount = conver_amont(data.cur_sell_settle_amount);
    //昨日环比
    let yesterday = initRate('昨日', conver_amont(data.pre_sell_settle_amount), calc_hb_str(data.cur_sell_settle_amount, data.pre_sell_settle_amount))
    hb.push(yesterday)
    //昨日环比
    let premonth = initRate('上月', conver_amont(data.pre_month_sell_settle_amount), calc_tb_str(data.cur_sell_settle_amount, data.pre_month_sell_settle_amount))
    hb.push(premonth)
  }
  if (type == 'cb') {
    turnOver.title = '成本'
    turnOver.amount = conver_amont(data.cur_buy_settle_amount);
    //昨日环比
    let yesterday = initRate('昨日', conver_amont(data.pre_buy_settle_amount), calc_hb_str(data.cur_buy_settle_amount, data.pre_buy_settle_amount))
    hb.push(yesterday)
    //昨日环比
    let premonth = initRate('上月', conver_amont(data.pre_month_buy_settle_amount), calc_tb_str(data.cur_buy_settle_amount, data.pre_month_buy_settle_amount))
    hb.push(premonth)
  }
  if (type == 'ml') {
    turnOver.title = '毛利'
    turnOver.amount = conver_amont(data.cur_gross_profit_amount);
    //昨日环比
    let yesterday = initRate('昨日', conver_amont(data.pre_gross_profit_amount), calc_hb_str(data.cur_gross_profit_amount, data.pre_gross_profit_amount))
    hb.push(yesterday)
    //昨日环比
    let premonth = initRate('上月', conver_amont(data.pre_month_gross_profit_amount), calc_tb_str(data.cur_gross_profit_amount, data.pre_month_gross_profit_amount))
    hb.push(premonth)
  }
  turnOver['hb'] = hb
  return turnOver;
}

/**
 * 初始化汇总数据
 * @returns {Object}
 */
export const initSumDataDay = function () {
  let turnOver = new Object()
  turnOver.title = '营业额'
  turnOver.amount = "0.0"
  let hb = new Array()
  let yesterday = initRate('昨日')
  hb.push(yesterday)
  yesterday = initRate('上月')
  hb.push(yesterday)
  turnOver.hb = hb
  return turnOver;
}

export const initRate = function (title, amount, rate) {
  let rateVo = new Object()
  rateVo.title = title
  rateVo.amount = amount ? amount : "0.0"
  rateVo.rate = rate ? rate : "0%"
  return rateVo;
}


/**
 * 月维度汇总
 * @param type
 * @param data
 */
export const adapterSumDataMonth = function (type, data) {
  let turnOver = initSumDataDay()
  let hb = new Array()
  if (type == 'yye') {
    turnOver.title = '营业额'
    turnOver.amount = conver_amont(data.cur_month_sell_settle_amount);
    //昨日环比
    let yesterday = initRate('上月', conver_amont(data.pre_month_sell_settle_amount), calc_hb_str(data.cur_month_sell_settle_amount, data.pre_month_sell_settle_amount))
    hb.push(yesterday)
    //昨日环比
    let premonth = initRate('去年', conver_amont(data.pre_year_sell_settle_amount), calc_tb_str(data.cur_month_sell_settle_amount, data.pre_year_sell_settle_amount))
    hb.push(premonth)
  }
  if (type == 'cb') {
    turnOver.title = '成本'
    turnOver.amount = conver_amont(data.cur_month_buy_settle_amount);
    //上月环比
    let yesterday = initRate('上月', conver_amont(data.pre_month_buy_settle_amount), calc_hb_str(data.cur_month_buy_settle_amount, data.pre_month_buy_settle_amount))
    hb.push(yesterday)
    //去年环比
    let premonth = initRate('去年', conver_amont(data.pre_year_buy_settle_amount), calc_tb_str(data.cur_month_buy_settle_amount, data.pre_year_buy_settle_amount))
    hb.push(premonth)
  }
  if (type == 'ml') {
    turnOver.title = '毛利'
    turnOver.amount = conver_amont(data.cur_month_gross_profit_amount);
    //昨日环比
    let yesterday = initRate('上月', conver_amont(data.pre_month_gross_profit_amount), calc_hb_str(data.cur_month_gross_profit_amount, data.pre_month_gross_profit_amount))
    hb.push(yesterday)
    //昨日环比
    let premonth = initRate('去年', conver_amont(data.pre_year_gross_profit_amount), calc_tb_str(data.cur_month_gross_profit_amount, data.pre_year_gross_profit_amount))
    hb.push(premonth)
  }
  turnOver['hb'] = hb
  return turnOver;
}

/**
 * 月维度汇总
 * @param type
 * @param data
 */
export const adapterSumDataYear = function (type, data) {
  let turnOver = initSumDataDay()
  let hb = new Array()
  if (type == 'yye') {
    turnOver.title = '营业额'
    turnOver.amount = conver_amont(data.cur_year_sell_settle_amount);
    //昨日环比
    let yesterday = initRate('去年', conver_amont(data.pre_year_sell_settle_amount), calc_hb_str(data.cur_year_sell_settle_amount, data.pre_year_sell_settle_amount))
    hb.push(yesterday)
  }
  if (type == 'cb') {
    turnOver.title = '成本'
    turnOver.amount = conver_amont(data.cur_year_buy_settle_amount);
    //上月环比
    let yesterday = initRate('去年', conver_amont(data.pre_year_buy_settle_amount), calc_hb_str(data.cur_year_buy_settle_amount, data.pre_year_buy_settle_amount))
    hb.push(yesterday)
  }
  if (type == 'ml') {
    turnOver.title = '毛利'
    turnOver.amount = conver_amont(data.cur_year_gross_profit_amount);
    //昨日环比
    let yesterday = initRate('去年', conver_amont(data.pre_year_gross_profit_amount), calc_hb_str(data.cur_year_gross_profit_amount, data.pre_year_gross_profit_amount))
    hb.push(yesterday)
  }
  turnOver['hb'] = hb
  return turnOver;
}


/**
 * 详细数据匹配
 * @param type
 * @param data
 * @returns {any[]}
 */
export const adapterDetailData = function (dimension, type, data) {
  let list = new Array()
  let detail = null
  for (let key in data) {
    detail = detailConver(type, data[key])
    let date;
    if (dimension == 'day') {
      date = moment(key).format('MM月DD日')
    }
    if (dimension == 'month') {
      date = moment(key).format('MM月')
    }
    if (dimension == 'year') {
      date = moment(key).format('YYYY年')
    }
    detail.date = date;
    list.push(detail);
  }
  return list;
}

/**
 * 详细数据转换
 * @param type
 * @param detailList
 * @returns {Object}
 */
export const detailConver = function (type, detailList) {
  let detail = initDetail();
  for (let det in detailList) {
    let data = detailList[det]
    //初始化
    if (type == 'yye') {
      if (data.cur_transport_type == '10') {
        detail['汽运(万元)'] = data.cur_sell_settle_amount;
      }
      if (data.cur_transport_type == '30') {
        detail['水运(万元)'] = data.cur_sell_settle_amount
      }
      if (data.cur_transport_type == '20') {
        detail['铁运(万元)'] = data.cur_sell_settle_amount
      }
    }
    if (type == 'cb') {
      if (data.cur_transport_type == '10') {
        detail['汽运(万元)'] = data.cur_buy_settle_amount
      }
      if (data.cur_transport_type == '30') {
        detail['水运(万元)'] = data.cur_buy_settle_amount
      }
      if (data.cur_transport_type == '20') {
        detail['铁运(万元)'] = data.cur_buy_settle_amount
      }
    }
    if (type == 'ml') {
      if (data.cur_transport_type == '10') {
        detail['汽运(万元)'] = data.cur_gross_profit_amount
      }
      if (data.cur_transport_type == '30') {
        detail['水运(万元)'] = data.cur_gross_profit_amount
      }
      if (data.cur_transport_type == '20') {
        detail['铁运(万元)'] = data.cur_gross_profit_amount
      }
    }
  }
  return detail;
}
/**
 * @returns {{}}
 */
export const initDetail = function () {
  let detail = {};
  detail['汽运(万元)'] = 0
  detail['水运(万元)'] = 0
  detail['铁运(万元)'] = 0
  return detail;
}

