import {
  getBusinessConditionDatas,
  getAllTypeBusinessConditionDatas,
  getAllTypeBusinessConditionDetailByDay,
  getBusinessConditionDataByMonth,
  getAllTypeBusinessConditionDatasByMonth,
  getAllTypeBusinessConditionDetailByMonth,
  getBusinessConditionDatasByYear,
  getAllTypeBusinessConditionDatasByYear,
  getAllTypeBusinessConditionDetailByYear,
  getBusinessConditionDatasByYoy, getDepartmentShipmentWeight, getDepartmentTargetWeight
} from "../../api/apiList";
import {calc_hb_str, calc_tb_str, conver_amont} from "../../utils/numUtil";
import moment from 'moment'
//天维度数据转换
export const getTrunOver = async function (dimension, type, cur_day) {
  let pageData = new Object();
  pageData.head = await getHead(dimension, type, cur_day)
  pageData.detail = await getDetail(dimension, type, cur_day)
  return pageData;
};

/**
 * @param cur_day
 */
export const getHead = async function (dimension, type, cur_day) {
  let typeName = new Object({"yye": "营业额", "cb": "成本", "ml": "毛利"});
  let pageName = typeName[type]
  let truck = "汽运" + pageName;
  let ship = "水运" + pageName;
  let tran = "铁运" + pageName;
  let headData = new Object();
  let transportData;
  let res = await reqDaySumData(dimension, cur_day);
  headData[pageName] = adapterSumData(dimension, type, res);
  transportData = await reqDayTransportData(dimension, cur_day)
  headData[truck] = initSumDataDay();
  headData[ship] = initSumDataDay();
  headData[tran] = initSumDataDay();
  if (transportData[10]) {
    headData[truck] = adapterSumData(dimension, type, transportData[10]);
  }
  if (transportData[30]) {
    headData[ship] = adapterSumData(dimension, type, transportData[30]);
  }
  if (transportData[20]) {
    headData[tran] = adapterSumData(dimension, type, transportData[20]);
  }
  return headData;
};
//获取折线图明细
export const getDetail = async function (dimension, type, cur_day) {
  let res;
  if (dimension == 'day') {
    res = await getAllTypeBusinessConditionDetailByDay(moment(cur_day).format('YYYY-MM'));
  }
  if (dimension == 'month') {
    res = await getAllTypeBusinessConditionDetailByMonth(cur_day)
  }
  if (dimension == 'year') {
    res = await getAllTypeBusinessConditionDetailByYear(cur_day)
  }
  if (dimension == 'yoy') {
    res = await getBusinessConditionDatasByYoy(cur_day)
  }
  let data = res.data
  return adapterDetailData(dimension, type, data)
};

//获取全部汇总数据
export const reqDaySumData = async function (dimension, cur_day) {
  let res;
  if (dimension == 'day') {
    res = await getBusinessConditionDatas(cur_day);
  }
  if (dimension == 'month') {
    res = await getBusinessConditionDataByMonth(cur_day);
  }
  if (dimension == 'year' || dimension == 'yoy') {
    res = await getBusinessConditionDatasByYear(cur_day);
  }
  let data = res.data
  return data;
}

//获取每个运输方式汇总数据
export const reqDayTransportData = async function (dimension, cur_day) {
  let res;
  if (dimension == 'day') {
    res = await getAllTypeBusinessConditionDatas(cur_day);
  }
  if (dimension == 'month') {
    res = await getAllTypeBusinessConditionDatasByMonth(cur_day);
  }
  if (dimension == 'year' || dimension == 'yoy') {
    res = await getAllTypeBusinessConditionDatasByYear(cur_day);
  }
  let data = res.data
  return data;
}


//获取明细数据数据
export const reqTransportDetailDayData = async function (cur_day) {
  let res = await getAllTypeBusinessConditionDetailByDay(moment(cur_day).format('YYYY-MM'));
  let data = res.data
  return data;
}


/**
 * 数据匹配
 * @param type
 * @param data
 */
export const adapterSumData = function (dimension, type, data) {
  let res;
  if (dimension == 'day') {
    res = adapterSumDataDay(type, data);
  }
  if (dimension == 'month') {
    res = adapterSumDataMonth(type, data);
  }
  if (dimension == 'year' || dimension == 'yoy') {
    res = adapterSumDataYear(type, data);
  }
  return res;
}


/**
 *日维度汇总
 * @param type yye:营业额、cb:成本、ml:毛利
 * @param data
 */
export const adapterSumDataDay = function (type, data) {
  let turnOver = initSumDataDay();
  let hb = new Array()
  if (type == 'yye') {
    turnOver.title = '营业额'
    turnOver.amount = conver_amont(data.cur_sell_settle_amount);
    //昨日环比
    let yesterday = initRate('昨日', conver_amont(data.pre_sell_settle_amount), calc_hb_str(data.cur_sell_settle_amount, data.pre_sell_settle_amount))
    hb.push(yesterday)
    //昨日环比
    let premonth = initRate('上月', conver_amont(data.pre_month_sell_settle_amount), calc_tb_str(data.cur_sell_settle_amount, data.pre_month_sell_settle_amount))
    hb.push(premonth)
  }
  if (type == 'cb') {
    turnOver.title = '成本'
    turnOver.amount = conver_amont(data.cur_buy_settle_amount);
    //昨日环比
    let yesterday = initRate('昨日', conver_amont(data.pre_buy_settle_amount), calc_hb_str(data.cur_buy_settle_amount, data.pre_buy_settle_amount))
    hb.push(yesterday)
    //昨日环比
    let premonth = initRate('上月', conver_amont(data.pre_month_buy_settle_amount), calc_tb_str(data.cur_buy_settle_amount, data.pre_month_buy_settle_amount))
    hb.push(premonth)
  }
  if (type == 'ml') {
    turnOver.title = '毛利'
    turnOver.amount = conver_amont(data.cur_gross_profit_amount);
    //昨日环比
    let yesterday = initRate('昨日', conver_amont(data.pre_gross_profit_amount), calc_hb_str(data.cur_gross_profit_amount, data.pre_gross_profit_amount))
    hb.push(yesterday)
    //昨日环比
    let premonth = initRate('上月', conver_amont(data.pre_month_gross_profit_amount), calc_tb_str(data.cur_gross_profit_amount, data.pre_month_gross_profit_amount))
    hb.push(premonth)
  }
  turnOver['hb'] = hb
  return turnOver;
}

/**
 * 初始化汇总数据
 * @returns {Object}
 */
export const initSumDataDay = function () {
  let turnOver = new Object()
  turnOver.title = '营业额'
  turnOver.amount = "0.0"
  let hb = new Array()
  let yesterday = initRate('昨日')
  hb.push(yesterday)
  yesterday = initRate('上月')
  hb.push(yesterday)
  turnOver.hb = hb
  return turnOver;
}

export const initRate = function (title, amount, rate) {
  let rateVo = new Object()
  rateVo.title = title
  rateVo.amount = amount ? amount : "0.0"
  rateVo.rate = rate ? rate : "0%"
  return rateVo;
}


/**
 * 月维度汇总
 * @param type
 * @param data
 */
export const adapterSumDataMonth = function (type, data) {
  let turnOver = initSumDataDay()
  let hb = new Array()
  if (type == 'yye') {
    turnOver.title = '营业额'
    turnOver.amount = conver_amont(data.cur_month_sell_settle_amount);
    //昨日环比
    let yesterday = initRate('上月', conver_amont(data.pre_month_sell_settle_amount), calc_hb_str(data.cur_month_sell_settle_amount, data.pre_month_sell_settle_amount))
    hb.push(yesterday)
    //昨日环比
    let premonth = initRate('去年', conver_amont(data.pre_year_sell_settle_amount), calc_tb_str(data.cur_month_sell_settle_amount, data.pre_year_sell_settle_amount))
    hb.push(premonth)
  }
  if (type == 'cb') {
    turnOver.title = '成本'
    turnOver.amount = conver_amont(data.cur_month_buy_settle_amount);
    //上月环比
    let yesterday = initRate('上月', conver_amont(data.pre_month_buy_settle_amount), calc_hb_str(data.cur_month_buy_settle_amount, data.pre_month_buy_settle_amount))
    hb.push(yesterday)
    //去年环比
    let premonth = initRate('去年', conver_amont(data.pre_year_buy_settle_amount), calc_tb_str(data.cur_month_buy_settle_amount, data.pre_year_buy_settle_amount))
    hb.push(premonth)
  }
  if (type == 'ml') {
    turnOver.title = '毛利'
    turnOver.amount = conver_amont(data.cur_month_gross_profit_amount);
    //昨日环比
    let yesterday = initRate('上月', conver_amont(data.pre_month_gross_profit_amount), calc_hb_str(data.cur_month_gross_profit_amount, data.pre_month_gross_profit_amount))
    hb.push(yesterday)
    //昨日环比
    let premonth = initRate('去年', conver_amont(data.pre_year_gross_profit_amount), calc_tb_str(data.cur_month_gross_profit_amount, data.pre_year_gross_profit_amount))
    hb.push(premonth)
  }
  turnOver['hb'] = hb
  return turnOver;
}

/**
 * 月维度汇总
 * @param type
 * @param data
 */
export const adapterSumDataYear = function (type, data) {
  let turnOver = initSumDataDay()
  let hb = new Array()
  if (type == 'yye') {
    turnOver.title = '营业额'
    turnOver.amount = conver_amont(data.cur_year_sell_settle_amount);
    //昨日环比
    let yesterday = initRate('去年', conver_amont(data.pre_year_sell_settle_amount), calc_hb_str(data.cur_year_sell_settle_amount, data.pre_year_sell_settle_amount))
    hb.push(yesterday)
  }
  if (type == 'cb') {
    turnOver.title = '成本'
    turnOver.amount = conver_amont(data.cur_year_buy_settle_amount);
    //上月环比
    let yesterday = initRate('去年', conver_amont(data.pre_year_buy_settle_amount), calc_hb_str(data.cur_year_buy_settle_amount, data.pre_year_buy_settle_amount))
    hb.push(yesterday)
  }
  if (type == 'ml') {
    turnOver.title = '毛利'
    turnOver.amount = conver_amont(data.cur_year_gross_profit_amount);
    //昨日环比
    let yesterday = initRate('去年', conver_amont(data.pre_year_gross_profit_amount), calc_hb_str(data.cur_year_gross_profit_amount, data.pre_year_gross_profit_amount))
    hb.push(yesterday)
  }
  turnOver['hb'] = hb
  return turnOver;
}


/**
 * 详细数据匹配
 * @param type
 * @param data
 * @returns {any[]}
 */
export const adapterDetailData = function (dimension, type, data) {
    if (dimension == 'yoy') {
      return adapterYoyDetailData(dimension, type, data)
    }else {
      return adapterColumnarData(dimension, type, data)
    }
}

/**
 * 柱状图数据组装
 * @param dimension
 * @param type
 * @param data
 */
export const adapterColumnarData = function (dimension, type, data) {
  let list = new Array()
  let detail = null
  for (let key in data) {
    detail = detailConver(type, data[key])
    let date;
    if (dimension == 'day') {
      date = moment(key).format('MM月DD日')
    }
    if (dimension == 'month') {
      date = moment(key).format('MM月')
    }
    if (dimension == 'year') {
      date = moment(key).format('YYYY年')
    }
    detail.date = date;
    list.push(detail);
  }
  return list;
}


export const adapterYoyDetailData = function (dimension, type, data) {
  return adapterYoyData(type,data)
}


/**
 * 折线图x
 * @param dimension
 * @param type
 * @param data
 */
export const adapterYoyData = function (type, data) {
  let pageDate = new Object();
  //汇总数据
  pageDate.sumData = adapterYoyYearData(data.cur_year+"汇总", data.pre_year+"汇总", type, data.year_data_sum)
  //汽运数据
  pageDate.tspt10 = adapterYoyYearData(data.cur_year+"汽运", data.pre_year+"汽运", type, data.year_data_transport.tspt_10)
  //铁运数据
  pageDate.tspt20 = adapterYoyYearData(data.cur_year+"铁运", data.pre_year+"铁运", type, data.year_data_transport.tspt_20)
  //水运数据
  pageDate.tspt30 = adapterYoyYearData(data.cur_year+"水运", data.pre_year+"水运", type, data.year_data_transport.tspt_30)
  return pageDate;
}

export const adapterYoyYearData = function (year,pre_year, type, data) {
  let pageDate = new Object();
  let xAxis = new Array();
  let series = new Array();
  //汇总数据
  let pre_year_sum_data = adapterYoySumData(type, data.pre_year_data) //去年同期对比
  xAxis.push(adapterXAxisData("red", pre_year_sum_data.month));
  series.push(adapterSeriesData(1,pre_year, pre_year_sum_data.lineData))
  let cur_year_sum_data = adapterYoySumData(type, data.cur_year_data) //今年数据
  xAxis.push(adapterXAxisData("#00bbe5", cur_year_sum_data.month));
  series.push(adapterSeriesData(null,year, cur_year_sum_data.lineData))
  pageDate.xAxis = xAxis;
  pageDate.series = series;
  return pageDate;
}

export const adapterYoySumData = function (type, data) {
  let yoyData = new Object();
  let month = new Array()
  let lineData = new Array()
  if(data != null) {
    for (var item of data) {
      if (type == 'yye') {
        lineData.push(item.cur_sell_settle_amount);
      }
      if (type == 'cb') {
        lineData.push(item.cur_buy_settle_amount);
      }
      if (type == 'ml') {
        lineData.push(item.cur_gross_profit_amount);
      }
      month.push(item.cur_month);
    }
  }
  yoyData.month = month;
  yoyData.lineData = lineData;
  return yoyData;
}





  /**
   * x轴数据
   * @param type
   * @param color
   * @param data
   * @returns {{data, axisLine: {lineStyle: {color}, onZero: boolean}, axisTick: {alignWithLabel: boolean}, axisPointer: {label: {formatter: (function(*): *)}}, type: string}}
   */
  export const adapterXAxisData = function (color, data) {
    return {
      type: 'category',
      axisTick: {
        alignWithLabel: true
      },
      axisLine: {
        onZero: false,
        lineStyle: {
          color: color
        }
      },
      axisPointer: {
        label: {
          formatter: function (params) {
            return ((params.seriesData.length ? params.seriesData[0].name+ '：' +   conver_amont(params.seriesData[0].value)+"万元": '')
            );
          }
        }
      },
      data: data
    }
  }

export const adapterXAxisData2 = function (color, data, targetValue) {
  return {
    type: 'category',
    axisTick: {
      alignWithLabel: true
    },
    axisLine: {
      onZero: false,
      lineStyle: {
        color: color
      }
    },
    axisPointer: {
      label: {
        formatter: function (params) {
          return params.seriesData[0].name + ' 目标量:' + targetValue;
        }
      }
    },
    data: data
  }
}

  /**
   * 业务数据加载
   * @param type
   * @param colors
   * @param data
   * @returns {{data: number[], xAxisIndex: number, name: string, emphasis: {focus: string}, type: string, smooth: boolean}}
   */
  export const adapterSeriesData = function (xAxisIndex, name, data) {
    return {
      name: name,
      type: 'line',
      xAxisIndex: xAxisIndex,
      smooth: true,
      emphasis: {
        focus: 'series'
      },
      data: data
    };
  }

  export const adapterSeriesDataBar = function (xAxisIndex, name, data) {
    return {
      name: name,
      type: 'bar',
      xAxisIndex: xAxisIndex,
      smooth: true,
      emphasis: {
        focus: 'series'
      },
      data: data
    };
  }


/**
 * 详细数据转换
 * @param type
 * @param detailList
 * @returns {Object}
 */
export const detailConver = function (type, detailList) {
  let detail = initDetail();
  for (let det in detailList) {
    let data = detailList[det]
    //初始化
    if (type == 'yye') {
      if (data.cur_transport_type == '10') {
        detail['汽运(万元)'] = data.cur_sell_settle_amount;
      }
      if (data.cur_transport_type == '30') {
        detail['水运(万元)'] = data.cur_sell_settle_amount
      }
      if (data.cur_transport_type == '20') {
        detail['铁运(万元)'] = data.cur_sell_settle_amount
      }
    }
    if (type == 'cb') {
      if (data.cur_transport_type == '10') {
        detail['汽运(万元)'] = data.cur_buy_settle_amount
      }
      if (data.cur_transport_type == '30') {
        detail['水运(万元)'] = data.cur_buy_settle_amount
      }
      if (data.cur_transport_type == '20') {
        detail['铁运(万元)'] = data.cur_buy_settle_amount
      }
    }
    if (type == 'ml') {
      if (data.cur_transport_type == '10') {
        detail['汽运(万元)'] = data.cur_gross_profit_amount
      }
      if (data.cur_transport_type == '30') {
        detail['水运(万元)'] = data.cur_gross_profit_amount
      }
      if (data.cur_transport_type == '20') {
        detail['铁运(万元)'] = data.cur_gross_profit_amount
      }
    }
    if (data.cur_transport_type == '10') {
      detail['汽运(万吨)'] = data.cur_unit_weight;
    }
    if (data.cur_transport_type == '20') {
      detail['铁运(万吨)'] = data.cur_unit_weight;
    }
    if (data.cur_transport_type == '30') {
      detail['水运(万吨)'] = data.cur_unit_weight;
    }
  }
  return detail;
}
/**
 * @returns {{}}
 */
export const initDetail = function () {
  let detail = {};
  detail['汽运(万元)'] = 0
  detail['水运(万元)'] = 0
  detail['铁运(万元)'] = 0

  detail['汽运(万吨)'] = 0
  detail['水运(万吨)'] = 0
  detail['铁运(万吨)'] = 0
  return detail;
}

export const getShipmentWeight = async function (department_code, cur_day) {
  let pageData = [];
  //曲线图数据
  let response = await getDepartmentShipmentWeight(department_code, cur_day);
  var xAxisData = [];
  var line1 = [];
  var line2 = [];
  response.data.forEach(function (row) {
    xAxisData.push(row.cur_day);
    line1.push(row.s__finished_weight_sum);
    line2.push(row.s__unfinished_weight_sum);
  });
  var series = [];
  series.push(adapterSeriesData(null, "完成量", line1));
  series.push(adapterSeriesData(null, "未完成量", line2));
  var xAxis = [];
  //目标量
  let targetResp = await getDepartmentTargetWeight(department_code, new Date().getFullYear());
  var target = targetResp.data ? Math.round(targetResp.data.settle_weight_sum/365*100)/100 : '无';
  xAxis.push(adapterXAxisData2("#00bbe5", xAxisData, target));

  var seriesBar = [];
  seriesBar.push(adapterSeriesDataBar(null, "完成量", line1));
  seriesBar.push(adapterSeriesDataBar(null, "未完成量", line2));

  pageData.xAxis = xAxis;
  pageData.series = series;
  pageData.seriesBar = seriesBar;
  console.log("--------------------", pageData);
  return pageData;
}
