import { getOrderFinishDataByCondition} from '../../../api/apiList';
import {calc_hb_str, calc_zb_str, conver_amont} from "../../../utils/numUtil";

let choice = {
    day: '昨日',
    month: "上月",
    year: "去年",
}

export const getHeadData = async (aux,callback) => {
  let resList = new Array();
  await getOrderFinishDataByCondition(aux).then(function (res) {
    resList = dataFormatter(aux,res.data);
  });
  callback(resList);
  return resList
}



function dataFormatter(aux,data){
  let res = new Array();
  if (aux.group_type === '01'){
    formatType01Data(aux,res, data);
  }else {
    formatNotType01Data(aux,res, data);
  }
  return res;
}

function formatNotType01Data(aux,res, data){
  let sum = {
    title: "当日",
    data: [
      {
        title: '订单量',
        today: 0,
        yesterday: 0,
      },
      {
        title: '营业额',
        today: 0,
        yesterday: 0,
      },
      {
        title: '成本',
        today: 0,
        yesterday: 0,
      },
      {
        title: '毛利',
        today: 0,
        yesterday: 0,
      },
    ]
  };
  res.push(sum);
  for (let key in data) {
    let item = {
      title: data[key].name?data[key].name:"空",
      key: key,
      data: [
        {
          title: "订单量",
          today: data[key].cur_unit_weight,
          yesterday: data[key].pre_unit_weight
        },
        {
          title: "营业额",
          today: data[key].cur_sell_settle_amount,
          yesterday: data[key].pre_sell_settle_amount
        },
        {
          title: "成本",
          today: data[key].cur_buy_settle_amount,
          yesterday: data[key].pre_buy_settle_amount
        },
        {
          title: "毛利",
          today: data[key].cur_gross_profit_amount,
          yesterday: data[key].pre_gross_profit_amount
        },
      ]
    };
    for (let i = 0; i < sum.data.length; i++) {
      sum.data[i].today += item.data[i].today;
      sum.data[i].yesterday += item.data[i].yesterday;
    }
    res.push(item);
  }
}

//转换领域细分数据
function formatType01Data(aux,res, data) {
  let sum = {
    title: "当日订单量(不含仓库)",
    amount: 0,
    hb: [
      {
        title: choice[aux.time_type],
        amount: 0,
        rate: "0.00%"
      }
    ]
  };
  res.push(sum);
  for (let key in data) {
    let item = {
      title: data[key].name?data[key].name:"空",
      amount: data[key].cur_unit_weight,
      key: key,
      hb: [
        {
          title: choice[aux.time_type],
          amount: conver_amont(data[key].pre_unit_weight),
          rate: calc_hb_str(data[key].cur_unit_weight, data[key].pre_unit_weight)
        }
      ]
    };
    sum.amount += data[key].cur_unit_weight;
    sum.hb[0].amount += data[key].pre_unit_weight;
    res.push(item);
  }
  calcProportion(res);
  sum.amount = conver_amont(sum.amount);
  sum.hb[0].amount = conver_amont(sum.hb[0].amount);
}

function calcProportion(list) {
  let sum = list[0];
  for (let i = 1; i < list.length; i++) {
    list[i].hb.push({
      title: "占比",
      amount: calc_zb_str(list[i].amount,sum.amount)
    })
    list[i].amount = conver_amont(list[i].amount);
  }

}

