import Vue from 'vue'
import Router from 'vue-router'
import Index from '../../databoard/index.vue'
import ArBar from "../../databoard/components/chart/ar-bar.vue";
import ArCompanyBar from "../../databoard/components/chart/ar-company-bar.vue";
import ArMonthlyBar from "../../databoard/components/chart/ar-monthly-bar.vue";
import ArCompanyMonthlyBar from "../../databoard/components/chart/ar-company-monthly-bar.vue";
import ArMonthlyCompanyBar from "../../databoard/components/chart/ar-monthly-company-bar.vue";
import TurnoverDetail from "../../databoard/databoard/turnover-detail.vue";
import OrderProportion from "../../databoard/databoard/order-proportion.vue";
import LostAddCustomer from "../../databoard/databoard/lost-add-customer.vue";


Vue.use(Router)

export default new Router({
  routes: [
    {
      path: '/',
      redirect: '/index'
    },
    {
      path: '/index',
      name: 'index',
      component: Index
    },
    {
      path: '/ar_bar',
      name: 'arBar',
      component: ArBar,
      children: [
        {
          path: '/ar_bar',
          redirect: '/ar_bar/company'
        },
        {
          path: '/ar_bar/company',
          name: 'arCompanyBar',
          component: ArCompanyBar
        },
        {
          path: '/ar_bar/company/monthly',
          name: 'arCompanyMonthlyBar',
          component: ArCompanyMonthlyBar
        },
        {
          path: '/ar_bar/monthly',
          name: 'arMonthlyBar',
          component: ArMonthlyBar
        },
        {
          path: '/ar_bar/monthly/company',
          name: 'arMonthlyCompanyBar',
          component: ArMonthlyCompanyBar
        }
      ]
    },
    {
      path: '/turnover-detail',
      name: 'turnoverDetail',
      component: TurnoverDetail
    },
    {
      path: '/order-proportion',
      name: 'OrderProportion',
      component: OrderProportion
    },
    {
      path: '/lost-add-customer',
      name: 'lostAddCustomer',
      component: LostAddCustomer
    }
  ]
})
