package logwire.web.bo;

import logwire.core.bo.eventhandler.ListOperationEventHandler;
import logwire.core.bo.eventhandler.ObjectOperationEventHandler;
import logwire.core.bo.eventhandler.TypeOperationEventHandler;
import logwire.core.bo.handler.ListOperationHandler;
import logwire.core.bo.handler.ObjectOperationHandler;
import logwire.core.bo.handler.TypeOperationHandler;
import logwire.core.bo.object.BizObject;
import logwire.core.meta.Config;
import logwire.core.resource.bean.BeanAdapter;

import java.util.ArrayList;
import java.util.List;

public class BoRelationDefinition extends BeanAdapter {

    public BoRelationDefinition(){

    }
    private boolean boServiceInitialized;

    @Config
    boolean isBizModel = false;

    @Config
    private Class<? extends BizObject> boClass;

    @Config
    private List<Class> typeOperationProviders = new ArrayList<>();

    @Config
    private List<Class> objectOperationProviders = new ArrayList<>();

    @Config
    private List<Class> listOperationProviders = new ArrayList<>();

    @Config
    private List<TypeOperationHandler> typeOperationHandlers = new ArrayList<>();

    @Config
    private List<ObjectOperationHandler> objectOperationHandlers = new ArrayList<>();

    @Config
    private List<ListOperationHandler> listOperationHandlers = new ArrayList<>();

    @Config
    private List<TypeOperationEventHandler> typeOperationEventHandlers = new ArrayList<>();

    @Config
    private List<ObjectOperationEventHandler> objectOperationEventHandlers = new ArrayList<>();

    @Config
    private List<ListOperationEventHandler> listOperationEventHandlers = new ArrayList<>();

    public List<Class> getTypeOperationProviders() {
        return typeOperationProviders;
    }

    public void setTypeOperationProviders(List<Class> typeOperationProviders) {
        this.typeOperationProviders = typeOperationProviders;
    }

    public void addTypeOperationProvider(Class typeOperationProvider) {
        this.typeOperationProviders.add(typeOperationProvider);
    }


    public List<Class> getObjectOperationProviders() {
        return objectOperationProviders;
    }

    public void setObjectOperationProviders(List<Class> objectOperationProviders) {
        this.objectOperationProviders = objectOperationProviders;
    }

    public void addObjectOperationProvider(Class objectOperationProvider) {
        this.objectOperationProviders.add(objectOperationProvider);
    }

    public List<Class> getListOperationProviders() {
        return listOperationProviders;
    }

    public void setListOperationProviders(List<Class> listOperationProviders) {
        this.listOperationProviders = listOperationProviders;
    }

    public void addListOperationProvider(Class listOperationProvider) {
        this.listOperationProviders.add(listOperationProvider);
    }

    public List<TypeOperationHandler> getTypeOperationHandlers() {
        return typeOperationHandlers;
    }

    public void setTypeOperationHandlers(List<TypeOperationHandler> typeOperationHandlers) {
        this.typeOperationHandlers = typeOperationHandlers;
    }

    public List<ObjectOperationHandler> getObjectOperationHandlers() {
        return objectOperationHandlers;
    }

    public void setObjectOperationHandlers(List<ObjectOperationHandler> objectOperationHandlers) {
        this.objectOperationHandlers = objectOperationHandlers;
    }

    public List<ListOperationHandler> getListOperationHandlers() {
        return listOperationHandlers;
    }

    public void setListOperationHandlers(List<ListOperationHandler> listOperationHandlers) {
        this.listOperationHandlers = listOperationHandlers;
    }


    public boolean isBizModel() {
        return isBizModel;
    }

    public void setBizModel(boolean bizModel) {
        isBizModel = bizModel;
    }


    public Class<? extends BizObject> getBoClass() {
        return boClass;
    }

    public void setBoClass(Class<? extends BizObject> boClass) {
        this.boClass = boClass;
    }

    public boolean isBoServiceInitialized() {
        return boServiceInitialized;
    }

    public void setBoServiceInitialized(boolean boServiceInitialized) {
        this.boServiceInitialized = boServiceInitialized;
    }

    public List<TypeOperationEventHandler> getTypeOperationEventHandlers() {
        return typeOperationEventHandlers;
    }

    public void setTypeOperationEventHandlers(List<TypeOperationEventHandler> typeOperationEventHandlers) {
        this.typeOperationEventHandlers = typeOperationEventHandlers;
    }

    public List<ObjectOperationEventHandler> getObjectOperationEventHandlers() {
        return objectOperationEventHandlers;
    }

    public void setObjectOperationEventHandlers(List<ObjectOperationEventHandler> objectOperationEventHandlers) {
        this.objectOperationEventHandlers = objectOperationEventHandlers;
    }

    public List<ListOperationEventHandler> getListOperationEventHandlers() {
        return listOperationEventHandlers;
    }

    public void setListOperationEventHandlers(List<ListOperationEventHandler> listOperationEventHandlers) {
        this.listOperationEventHandlers = listOperationEventHandlers;
    }
}
