package logwire.web.bo.field.parse;

import logwire.core.meta.model.fields.BigIntegerField;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;

public class BigIntegerFieldParser extends FieldParser<BigIntegerField> {

    @Override
    protected BigIntegerField newField(Field field, Annotation[] annotations) {
        return new BigIntegerField(field.getName());
    }

    @Override
    protected void setField(BigIntegerField newField, Annotation[] annotations) {

    }

    private BigIntegerFieldParser() {
    }

    public static BigIntegerFieldParser getInstance() {
        return BigIntegerFieldParser.SingletonHolder.instance;
    }

    private static class SingletonHolder {
        private static BigIntegerFieldParser instance = new BigIntegerFieldParser();
    }
}
