package logwire.web.bo.field.parse;

import logwire.core.meta.model.fields.StringField;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;

public class BizArrayFieldParser extends FieldParser<StringField> {

    @Override
    protected StringField newField(Field field, Annotation[] annotations) {
        return new StringField(field.getName(), 100);
    }

    private BizArrayFieldParser() {
    }

    public static BizArrayFieldParser getInstance() {
        return BizArrayFieldParser.SingletonHolder.instance;
    }

    private static class SingletonHolder {
        private static BizArrayFieldParser instance = new BizArrayFieldParser();
    }
}
