package logwire.web.bo.field.parse;

import logwire.core.meta.model.fields.BooleanField;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;

public class BooleanFieldParser extends FieldParser<BooleanField> {
    @Override
    protected BooleanField newField(Field field, Annotation[] annotations) {
        return new BooleanField(field.getName());
    }

    private BooleanFieldParser() {
    }

    public static BooleanFieldParser getInstance() {
        return BooleanFieldParser.SingletonHolder.instance;
    }

    private static class SingletonHolder {
        private static BooleanFieldParser instance = new BooleanFieldParser();
    }
}
