package logwire.web.bo.field.parse;

import logwire.core.meta.model.fields.DateTimeField;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;

public class DateTimeFieldParser extends FieldParser<DateTimeField> {

    @Override
    protected DateTimeField newField(Field field, Annotation[] annotations) {
        return new DateTimeField(field.getName());
    }

    private DateTimeFieldParser() {
    }

    public static DateTimeFieldParser getInstance() {
        return DateTimeFieldParser.SingletonHolder.instance;
    }

    private static class SingletonHolder {
        private static DateTimeFieldParser instance = new DateTimeFieldParser();
    }
}
