package logwire.web.bo.field.parse;

import logwire.core.meta.model.fields.DecimalField;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;

public class DecimalFieldParser extends FieldParser<DecimalField> {

    @Override
    protected DecimalField newField(Field field, Annotation[] annotations) {
        return new DecimalField(field.getName(), 18, 6);
    }

    private DecimalFieldParser() {
    }

    public static DecimalFieldParser getInstance() {
        return DecimalFieldParser.SingletonHolder.instance;
    }

    private static class SingletonHolder {
        private static DecimalFieldParser instance = new DecimalFieldParser();
    }
}
