package logwire.web.bo.field.parse;

import logwire.core.bo.field.BizArray;

import java.lang.annotation.Annotation;
import java.time.OffsetDateTime;

public abstract class FieldParserUtil {

    private FieldParserUtil() {
    }

    /**
     * 获取解析注解的 parser
     *
     * @param field
     * @param annotations
     * @return
     */
    public static FieldParser getParser(java.lang.reflect.Field field, Annotation[] annotations) {
        return getParserByFieldType(field);
    }

    private static FieldParser getParserByFieldType(java.lang.reflect.Field field) {
        // 此时一定是存在 Field 类型的 annotation
        // 根据字段类型来推断 Parser
        Class clazz = field.getType();
        if (clazz.equals(String.class)) {
            return StringFieldParser.getInstance();
        } else if (clazz.equals(Integer.class) || clazz.equals(int.class)) {
            return IntegerFieldParser.getInstance();
        } else if (clazz.equals(Short.class) || clazz.equals(short.class)) {
            return SmallIntegerFieldParser.getInstance();
        } else if (clazz.equals(Long.class) || clazz.equals(long.class)) {
            return BigIntegerFieldParser.getInstance();
        } else if (clazz.equals(OffsetDateTime.class) || clazz.equals(java.util.Date.class)) {
            return DateTimeFieldParser.getInstance();
        } else if (clazz.equals(Boolean.class) || clazz.equals(boolean.class)) {
            return BooleanFieldParser.getInstance();
        } else if (clazz.equals(Double.class) || clazz.equals(double.class) || clazz.equals(float.class)) {
            return DecimalFieldParser.getInstance();
        } else if (clazz.equals(BizArray.class)) {
            return BizArrayFieldParser.getInstance();
        }
        return null;
    }
}
