package logwire.web.bo.field.parse;

import logwire.core.meta.model.fields.IntegerField;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;

public class IntegerFieldParser extends FieldParser<IntegerField> {
    @Override
    protected IntegerField newField(Field field, Annotation[] annotations) {
        return new IntegerField(field.getName());
    }

    private IntegerFieldParser() {
    }

    public static IntegerFieldParser getInstance() {
        return IntegerFieldParser.SingletonHolder.instance;
    }

    private static class SingletonHolder {
        private static IntegerFieldParser instance = new IntegerFieldParser();
    }
}
