package logwire.web.bo.field.parse;

import logwire.core.meta.model.fields.SmallIntegerField;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;

public class SmallIntegerFieldParser extends FieldParser<SmallIntegerField> {
    @Override
    protected SmallIntegerField newField(Field field, Annotation[] annotations) {
        return new SmallIntegerField(field.getName());
    }

    private SmallIntegerFieldParser() {
    }

    public static SmallIntegerFieldParser getInstance() {
        return SmallIntegerFieldParser.SingletonHolder.instance;
    }

    private static class SingletonHolder {
        private static SmallIntegerFieldParser instance = new SmallIntegerFieldParser();
    }
}
