package logwire.web.bo.field.parse;

import logwire.core.meta.model.fields.StringField;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;

public class StringFieldParser extends FieldParser<StringField> {
    @Override
    protected StringField newField(Field field, Annotation[] annotations) {
        return new StringField(field.getName(), 50);
    }

    private StringFieldParser() {
    }

    public static StringFieldParser getInstance() {
        return StringFieldParser.SingletonHolder.instance;
    }

    private static class SingletonHolder {
        private static StringFieldParser instance = new StringFieldParser();
    }

}
