package logwire.web.bo.listener;

import logwire.core.meta.query.IQuery;
import logwire.core.meta.query.Query;
import logwire.web.action.listener.ActionListener;
import logwire.web.bo.query.BizModelQuery;
import logwire.web.bo.session.Session;
import logwire.web.bo.session.SessionHolder;
import logwire.web.service.ActionContext;
import logwire.web.service.query.QueryService;
import logwire.web.tenant.TenantProjectService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;


@Component
public class BoActionListener implements ActionListener {

    @Autowired
    TenantProjectService projectService;

    @Autowired
    QueryService queryService;

    @Override
    public void beforeAction(ActionContext actionContext, String queryName) {
        IQuery iQuery = projectService.getCurrentProject().findQuery(queryName);
        if (iQuery == null) {
            return;
        }
        if (!(iQuery instanceof Query)) {
            return;
        }
        Query query = (Query) iQuery;

        if (query instanceof BizModelQuery) {
            SessionHolder.openSession(actionContext);
        }

    }

    @Override
    public void afterAction(ActionContext actionContext, String queryName) {
        Session session = SessionHolder.getSession();
        if (session != null) {
            session.commit(queryService);
        }

    }
}
