package logwire.web.bo.loader;

import logwire.core.bo.eventhandler.OperationEventHandler;
import logwire.core.bo.handler.OperationHandler;
import logwire.core.bo.object.BizObject;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.stereotype.Component;

import java.io.IOException;

@Component
public class LoaderUtil {

    public LogwireClassPathScanningCandidateComponentProvider getScanningBeanProvider() {
        return new LogwireClassPathScanningCandidateComponentProvider(false);
    }

    public TypeFilter getAbstractTypeFilter(Class targetType) {
        return new AbstractTypeFilter(targetType);

    }

    public boolean isBizObject(Class<?> beanClass) {
        return BizObject.class.isAssignableFrom(beanClass);
    }

    public boolean isOperationHandler(Class<?> beanClass) {
        return OperationHandler.class.isAssignableFrom(beanClass);
    }

    public boolean isOperationEventHandler(Class<?> beanClass) {
        return OperationEventHandler.class.isAssignableFrom(beanClass);
    }

    private class AbstractTypeFilter extends AssignableTypeFilter {
        public AbstractTypeFilter(Class<?> targetType) {
            super(targetType);
        }

        public boolean match(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) throws IOException {
            return metadataReader.getClassMetadata().isAbstract()
                    // 重写父类，增加判断，排除掉指定的接口 （targetType） 本身
                    && !metadataReader.getClassMetadata().getClassName().equals(getTargetType().getName())
                    && super.match(metadataReader, metadataReaderFactory);
        }
    }


    private class LogwireClassPathScanningCandidateComponentProvider extends ClassPathScanningCandidateComponentProvider {
        public LogwireClassPathScanningCandidateComponentProvider(boolean useDefaultFilters) {
            super(useDefaultFilters);
        }

        @Override
        protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
            AnnotationMetadata metadata = beanDefinition.getMetadata();
            return metadata.isIndependent();
        }
    }
}
