package logwire.web.bo.provider;

import logwire.core.bo.annotation.Operation;
import logwire.core.bo.annotation.TypeOperationProvider;
import logwire.core.bo.list.BizList;
import logwire.core.bo.object.BizObject;
import logwire.core.bo.select.BizSelect;

import java.util.List;
import java.util.Map;

@TypeOperationProvider(type = BizObject.class)
public interface DefaultTypeOperationProvider {
    @Operation(label = "创建BO对象")
    <X> X create();

    @Operation()
    <X> X create(Map defaultValues);

    @Operation()
    <X> X create(String query);

    @Operation()
    <X> X find(Long id);

    @Operation()
    <X> X find(Map fields);

    @Operation()
    <X> X find(String query);

    @Operation()
    <X> X find(String query, List fieldValues);

    @Operation()
    <X extends BizObject> BizList<X> createList();

    @Operation()
    <X extends BizObject> BizList<X> createList(String query);

    @Operation()
    <X extends BizObject> BizList<X> createList(Map fields);

    @Operation()
    <X extends BizObject> BizList<X> findAll(Map fields);

    @Operation()
    <X extends BizObject> BizList<X> findAll(String query);

    @Operation()
    <X extends BizObject> BizList<X> findAll(String query, List fieldValues);

    @Operation()
    BizSelect select();

    @Operation()
    BizSelect select(Map fields);

    @Operation()
    BizSelect select(String query);

    @Operation()
    <X> X delete(Long id);

    @Operation()
    List<Object> findField(String query, String field);

    @Operation()
    List<Map> findFields(String query, String... fields);
    // 更多Operation
}
