package logwire.web.bo.proxy;

import logwire.core.bo.object.BizObject;
import logwire.web.bo.BoRelationDefinition;
import logwire.web.bo.provider.DefaultTypeOperationProvider;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.matcher.ElementMatchers;

public class Proxy {
    /**
     *
     * 初始化 BO的 service : TypeOperationProvider
     *
     * @param boRelationDefinition
     * @return
     * @throws IllegalAccessException
     * @throws InstantiationException
     * @throws NoSuchFieldException
     */
    public static Object createTypeOperationProvider(BoRelationDefinition boRelationDefinition) throws IllegalAccessException, InstantiationException, NoSuchFieldException {
        Class<? extends BizObject> beanClass = boRelationDefinition.getBoClass();

        // 动态生成service
        // 若直接继承了BizObject,则动态代理继承DefaultTypeOperationProvider，否则继承父类中的service对应的TypeOperationProvider
        Class superClass = DefaultTypeOperationProvider.class;
        if (beanClass.getSuperclass() != BizObject.class) {
            // parent TypeOperationProvider
            superClass = beanClass.getSuperclass().getField("serivce").getClass();
        }
        return new ByteBuddy().subclass(superClass)
                .implement(boRelationDefinition.getTypeOperationProviders())
                .method(ElementMatchers.any())
                .intercept(MethodDelegation.to(new TypeOperationInterceptor(boRelationDefinition)))
                .make()
                .load(beanClass.getClassLoader())
                .getLoaded().newInstance();
    }
}
