package logwire.web.bo.proxy;


import logwire.core.bo.handler.Handler;
import logwire.core.bo.object.BizObject;
import logwire.web.bo.BoRelationDefinition;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.SuperMethod;
import net.bytebuddy.implementation.bind.annotation.This;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;


public class TypeOperationInterceptor {

    private static final Logger logger = LoggerFactory.getLogger(TypeOperationInterceptor.class);

    private BoRelationDefinition boRelationDefinition;

    public TypeOperationInterceptor(BoRelationDefinition boRelationDefinition) {
        this.boRelationDefinition = boRelationDefinition;

    }

    public Object interceptor(@This Object proxy, @Origin Method method,
                              @SuperMethod Method superMethod,
                              @AllArguments Object[] args) throws Exception {
        if (superMethod != null) {
            return superMethod.invoke(proxy, args);
        }
        return doHandler(method, args);
    }

    /**
     * 根据methodName执行对应的handler
     */
    private Object doHandler(Method method, Object[] args) {
        Class<? extends BizObject> bizClazz = boRelationDefinition.getBoClass();
        String operationName = method.getName();
        logger.debug("Execute operation {} start", new Object[]{operationName});
        getHandler(operationName, boRelationDefinition.getTypeOperationEventHandlers(),
                typeOperationEventHandler -> !typeOperationEventHandler.isAfter())
                .doBefore(bizClazz, args);

        Object result = getHandler(operationName, boRelationDefinition.getTypeOperationHandlers(),
                typeOperationHandler -> typeOperationHandler.accept(bizClazz, args))
                .execute(bizClazz, args);

        getHandler(operationName, boRelationDefinition.getTypeOperationEventHandlers(),
                typeOperationEventHandler -> typeOperationEventHandler.isAfter())
                .doAfter(bizClazz, result, args);
        return result;
    }


    private <T extends Handler> T getHandler(String operation, List<T> handlers, Function<T, Boolean> function) {
        return handlers.stream()
                .filter(handler -> operation.equals(handler.getOperation()) && function.apply(handler))
                .max(Comparator.comparing(T::getOrder)).get();
    }

}

