package logwire.web.bo.session;

import logwire.core.exceptions.ApplicationException;
import logwire.web.service.ActionContext;
import org.springframework.core.NamedThreadLocal;

/**
 * SessionHolder
 *
 */
public abstract class SessionHolder {

    private static ThreadLocal<Session> sessionThreadLocal = new NamedThreadLocal<>("Biz context");

    public static Session getSessionOrFail() {
        Session session = sessionThreadLocal.get();
        if (session != null) {
            return session;
        }
        throw new ApplicationException("No session exists, please call method SessionHolder.openSession() to open a new session!");
    }

    public static Session getSession() {
        return sessionThreadLocal.get();
    }

    public static Session openSession(ActionContext context) {
        Session session = sessionThreadLocal.get();
        if (session == null) {
            session = new Session(context);
            sessionThreadLocal.set(session);
        }
        return session;
    }

    public static void clear() {
        sessionThreadLocal.remove();
    }

}
