package logwire.core.bo.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * BO类声明为Model的注解
 */
@Target({ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
public @interface BizModel {

    String label() default "";

    /**
     * 缓存策略说明：
     * cache="24h":在BO数据修改/刪除时会清除缓存，使用时先从redis取，
     *             如果不存在，再从数据库取并推入缓存，缓存24小时后自动清除。
     * cache="true":不会自动失效
     * @return
     */
    String cache() default "";

    /**
     * 业务关键字段，输出Debug日志时使用
     * @return
     */
    String bizKey() default "";

}
