package logwire.core.bo.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Target({ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
public @interface Operation {

    String label() default "";

    OperationArg[] args() default {};

    /**
     * 对结果做线程缓存，当self、输入参数一致时直接返回上次计算结果
     *
     * @return
     */
    boolean cached() default false;
}
