package logwire.core.bo.field;

import logwire.core.bo.object.BizObject;
import logwire.core.bo.list.BizList;

import java.lang.reflect.Field;
import java.util.Map;

public interface BizItem<X extends BizObject> extends Iterable<X> {
    boolean isChanged();

    X find(String field, Object value);

    X find(Map<String, Field> fields);

    X create();

    X create(Map<String, Field> fields);

    BizList<X> findAll(String field, Object value);

    BizList<X> findAll(Map fields);
}
