package logwire.core.bo.object;

import logwire.core.bo.annotation.Column;
import logwire.core.bo.annotation.Composite;
import logwire.core.bo.field.BizExpando;
import logwire.core.bo.field.BizOne;
import java.time.OffsetDateTime;
import java.util.Map;

/**
 * BO 生成的Model,audit=false version=true domain=true, 指定ID为主键，非AUTO；audit由BO控制
 * BO 子表字段(多对多、数组、大文本)生成的Model，audit/version/domain都为false
 */
public abstract class BizObject extends ModelObject {
    /**
     * 事务类型 insert/update/delete
     */
    String _TX_CODE;

    /**
     * 当事务类型为update时，记录修改过的字段
     */
    Map<String, Object> UPDATED_FIELDS;

    @Column(label = "主键")
    Long id;// BO 的ID全部为雪花ID
    @Column(label = "版本号")
    int version;
    @Column(label = "BO名称")
    String boName;
    @Column(label = "创建用户")
    BizOne<User> createUser;
    @Column(label = "创建时间")
    OffsetDateTime createDate;
    @Column(label = "最后修改用户")
    BizOne<User> updateUser;
    @Column(label = "最后修改时间")
    OffsetDateTime updateDate;
    @Composite(label = "项目扩展字段", prefix = "exp_")
    BizExpando exps;
    @Column(label = "域")
    String domain;
}
