// https://nuxt.com/docs/api/configuration/nuxt-config
export default defineNuxtConfig({
  ssr: false,
  devtools: { enabled: true },
  modules: ['@pinia/nuxt'],
  css: ['~/assets/css/main.css', '~/assets/css/color.css'],
  nitro: {
    experimental: {
      websocket: true
    }
  },
  runtimeConfig: {
    pgUser: '',
    pgPort: '',
    pgHost: '',
    pgPassword: '',
    pgDatabase: '',
    public: {
      dockerHost: ''
    }
  }
})
