import { getPlatformRootFolder } from "~/server/utils/server"

export default defineEventHandler(async (event) => {
  try {
    const body = await readBody(event)
    let username = event.context.username
    let docker = createDockerFactory(username)
    let branch = body.branch
    let container = await docker.checkContainer( username + '.node')
    const dir = getPlatformRootFolder(body.platform)
    if (container) {
      await docker.startContainer({ container })
      await docker.execContainerCommand({ container, cmd: 'git fetch', dir })
      if (branch === 'master') {
        await docker.execContainerCommand({ container, cmd: 'git checkout master', dir })
        await docker.execContainerCommand({ container, cmd: 'git pull', dir })
      } else {
        await docker.execContainerCommand({ container, cmd: 'git checkout master', dir })
        try {
          await docker.execContainerCommand({ container, cmd: 'git branch -D ' + branch, dir })
        } catch (err) {
          // 有可能没有本地分支，这样删除会报错，但是忽视
        }
        await docker.execContainerCommand({ container, cmd: 'git checkout ' + branch, dir })
      }
    } else {
      throw new Error('没有创建容器，请先初始化容器')
    }
  } catch (err) {
    setResponseStatus(event, 500)
    return err
  }
})