export default defineEventHandler(async (event) => {
  const body = await readBody(event)
  let gitEmail = body.email
  let username = event.context.username
  let docker = createDockerFactory(username)
  // 创建 node 容器
  let container = await docker.checkContainer( username + '.node')
  if (container) {
    await docker.startContainer({ container })
    await docker.execContainerCommand({ container, cmd: 'rm -rf /root/.ssh' })
    await docker.execContainerCommand({ container, cmd: `ssh-keygen -f /root/.ssh/id_rsa -t ed25519 -C "${gitEmail}"` })
    let sshKey = await docker.getFile({ container, path: '/root/.ssh/id_rsa.pub' })
    return sshKey
  }
})