import { TableUser } from "~/server/utils/postgres"
import { SESSION_PASSWORD } from "../../utils"

export default defineEventHandler(async (event) => {
  const body = await readBody(event)
  const username = body.username
  const session = await useSession(event, { password: SESSION_PASSWORD, cookie: { secure: false } })
  await session.update({ username })
  
  let user = await getPgTableData('user', username)
  if (!user) {
    const port = await getAvailableNodePort(useRuntimeConfig().public.dockerHost)
    await insertPgTableData('user', username)
    await setPgTableData('user', username, 'port', port)
    user = await getPgTableData('user', username)
  }

  return user
})