import type { NitroApp } from "nitropack";
import { ApolloServer, ContextFunction, HeaderMap } from '@apollo/server'
import { startStandaloneServer } from "@apollo/server/standalone";
import Resolvers from '../../public/apollo/resolvers/query'
import fs from 'fs'

function readGraphqlString (filename: string) {
  const path = './public/apollo/typeDefs/' + filename + '.graphql'
  return fs.readFileSync(path, { encoding: 'utf-8' })
}

export default defineNitroPlugin((nitroApp: NitroApp) => {
  const resolvers = Resolvers
  const query = readGraphqlString('query')
  const user = readGraphqlString('user')
  const v2 = readGraphqlString('v2')
  const v1 = readGraphqlString('v1')
  const typeDefs = `
  ${query}
  ${user}
  ${v2}
  ${v1}
  `
  const server = new ApolloServer({
    typeDefs,
    resolvers,
    csrfPrevention: false
  })
  startStandaloneServer(server).then(() => {
    console.log('apollo started')
  })
  nitroApp.router.use('/graphql', defineEventHandler({
    async handler (event) {
      console.log('in graphql')
      const headers = new HeaderMap();
      for (const [key, value] of Object.entries(event.headers)) {
        if (value !== undefined) {
          headers.set(key, Array.isArray(value) ? value.join(', ') : value);
        }
      }
      const body = await readBody(event)
      return server.executeHTTPGraphQLRequest({
        httpGraphQLRequest: {
          method: event.method.toUpperCase(),
          headers,
          search: '',
          body
        },
        context: () => {
          return Promise.resolve({})
        }
      }).then((value) => {
        setResponseHeader(event, 'Content-Type', 'application/json')
        if (value.body.kind === 'complete') return value.body.string
        return value.body
      }).catch(err => {
        console.log('err', err)
      })
    }
  }))
})