import { defineStore } from 'pinia'

export const useUserStore = defineStore('user', () => {
  const username = ref('')
  const port = ref(0)
  const branchV1 = ref('')
  const branchV2 = ref('')

  function setUserName (payload: { username: string }) {
    username.value = payload.username
  }
  function setPort (payload: { port: number }) {
    port.value = payload.port
  }
  function setBranchV1 (payload: { branchV1: string }) {
    branchV1.value = payload.branchV1
  }
  function setBranchV2 (payload: { branchV2: string }) {
    branchV2.value = payload.branchV2
  }

  return { username, port, branchV1, branchV2, setUserName, setPort , setBranchV1, setBranchV2 }
})