/**
 * useWaitingFetch
 * 等待一定时间后再返回，避免接口时间太短引起页面渲染时的一闪而过的情况
 */
import nitropack from 'nitropack'

export default async function<R extends nitropack.NitroFetchRequest> (
  url: R,
  options: nitropack.NitroFetchOptions<R> & { wait: number }
): ReturnType<nitropack.$Fetch> {
  const startTimestamp = +new Date()
  const result = await $fetch(url, options)
  const endTimestamp = +new Date()
  const gap = endTimestamp - startTimestamp
  if (gap < options.wait) {
    await sleep(options.wait - gap)
  }
  return result
}