import LogUtil from "~/server/utils/log"

export default defineEventHandler(async (event) => {
  let username = event.context.username
  try {
    let username = event.context.username
    LogUtil.clear(username)
    let docker = createDockerFactory(username)
    let container = await docker.checkContainer( username + '.node')
    let rowUser = await getPgTableData( 'user', username)
    let rowV2 = await getPgTableData( 'v2', username)
    let tenants = rowV2?.tenants
    let port = rowUser?.["port"]

    LogUtil.printInfo(username, `程序初始化中......`)
    await changeProjectStatus( 'v2', username, 'status', 'running')
    if (!container) {
      throw new Error('没有创建容器，请先初始化容器')
    }

    await copyAndCreateServerPropertiesV2InDocker(username)
    await copyAndCreateGatewayPropertiesV2InDocker(username)

    // 有可能本身就关闭了
    try {
      await docker.execContainerCommand({ container, cmd: 'nginx -s stop'})
    } catch (err) {}

    await docker.preStartSystem({ container, username, platform: 'v2'})
    await copyAndCreateNginxConfInDocker(username)
    await docker.execContainerCommand({ container, cmd: 'nginx'})

    await docker.execContainerCommand({ container, cmd: 'pm2 start --name gateway --no-autorestart java -- -Xms256m -Xmx256m -XX:+UseG1GC --add-opens java.base/sun.util.locale.provider=ALL-UNNAMED -DbootUserName=root -jar logwire-gateway-starter.jar', dir: '/var/logwire-backend/build-output/gateway', quiet: true })
    await docker.execContainerCommand({ container, cmd: `pm2 start --name backend --no-autorestart java -- -Xms256m -Xmx256m -XX:+UseG1GC -DVALIDATE_XML_ENABLED=false --add-opens java.base/sun.util.locale.provider=ALL-UNNAMED --add-opens java.desktop/sun.awt=ALL-UNNAMED -DbootUserName=root -jar logwire-backend-starter.jar`, dir: '/var/logwire-backend/build-output/backend', quiet: true })

    LogUtil.printInfo(username, `程序运行中......`)
    LogUtil.printInfo(username, `请代理后端请求到 <strong>${HOST}:${port}</strong> 上`)
    LogUtil.printInfo(username, `请设置开发环境域名和端口号 <strong>${tenants?.host}</strong> 上`)

    await changeProjectStatus( 'v2', username, 'status', 'launched')
  } catch (err) {
    await changeProjectStatus( 'v2', username, 'status', 'compiled')
    LogUtil.printError(username, (err instanceof Error ? err.message : JSON.stringify(err)))
    setResponseStatus(event, 500)
    return err
  }
})