import LogUtil from "~/server/utils/log"

export default defineEventHandler(async (event) => {
    let username = event.context.username
    LogUtil.clear(username)
    let docker = createDockerFactory(username)
    let container = await docker.checkContainer( username + '.node')
    if (!container) {
      throw new Error('没有创建容器，请先初始化容器')
    }
    LogUtil.printInfo(username, `程序停止中......`)
    await changeProjectStatus( 'v2', username, 'status', 'stopping')
    await docker.execContainerCommand({ container, cmd: 'pm2 delete backend', quiet: true })
    await docker.execContainerCommand({ container, cmd: 'pm2 delete gateway', quiet: true })
    LogUtil.print(username, `程序已停止`)

    await changeProjectStatus( 'v2', username, 'status', 'compiled')
})