import { getPlatformRootFolder } from "~/server/utils/server"

export default defineEventHandler(async (event) => {
  try {
    const query = getQuery(event)
    let username = event.context.username
    let docker = createDockerFactory(username)
    let container = await docker.checkContainer( username + '.node')
    const platform = query.platform as 'v1' | 'v2'
    if (container) {
      await docker.startContainer({ container })
      let result = await docker.execContainerCommand({ container, cmd: 'git branch -a', dir: getPlatformRootFolder(platform) })
      result = result.split('\n')
        .map(o => o.replace('*', '').trim())
        .filter(o => o.startsWith('remotes/origin/'))
        .map(o => o.replace('remotes/origin/', ''))
        .join('\n')
      return removeUnreadCharacter(result)
    } else {
      throw new Error('没有创建容器，请先初始化容器')
    }
  } catch (err) {
    setResponseStatus(event, 500)
    return err
  }
})