import { getPlatformRootFolder } from "~/server/utils/server"

export default defineEventHandler(async (event) => {
  try {
    const query = getQuery(event)
    const { platform } = query
    let username = event.context.username
    let docker = createDockerFactory(username)
    let container = await docker.checkContainer(username + '.node')
    if (container) {
      await docker.startContainer({ container })
      let result = await docker.execContainerCommand({ container, cmd: 'git branch', dir: getPlatformRootFolder(platform as 'v1' | 'v2') })
      const arrays = result.split('\n')
      let currentBranch = arrays.find(o => o.includes('*'))
      currentBranch = currentBranch?.replace(/^.*?\*/, '').trim() || ''
      return removeUnreadCharacter(currentBranch)
    } else {
      throw new Error('没有创建容器，请先初始化容器')
    }
  } catch (err) {
    setResponseStatus(event, 500)
    return err
  }
})