import { SESSION_PASSWORD } from "../utils"


declare module 'h3' {
  interface H3EventContext {
    username: string
  }
}

export default defineEventHandler(async (event) => {
  const session = await useSession(event, { password: SESSION_PASSWORD })
  if (session.data && session.data.username) {
    event.context.username = session.data.username
  } else {
    const nonAuthorizedUrls = ['/login', '/', '/api/user/login']
    const url = event.node.req.url || '/'
    if (!nonAuthorizedUrls.includes(url)) {
      throw createError({
        statusCode: 401,
        message: '未授权'
      })
    }
  }
})