import LogUtil from "~/server/utils/log"

export default defineEventHandler(async (event) => {
  let username = event.context.username
  try {
    let username = event.context.username
    LogUtil.clear(username)
    let docker = createDockerFactory(username)

    await changeProjectStatus( 'v2', username, 'status', 'compiling')

    const rowV1 = await getPgTableData('v1', username)
    if (rowV1?.status === 'launched') {
      await changeProjectStatus('v1', username, 'status', 'compiled')
    }
    // TODO: 在后端发送 websocket 通知前端状态变更
    // 每次编译前把已有的 tenants_config 文件夹拷贝到一个地方，编译完成后，再拷贝回来

    let container = await docker.checkContainer( username + '.node')
    if (!container) {
      throw new Error('没有创建容器，请先初始化容器')
    }
    await docker.startContainer({ container })

    await docker.preStartSystem({ container, username, platform: 'v2'})
    try {
      await docker.execContainerCommand({ container, cmd: 'mv -bf build-output/backend/tenants_config/ ../tenants_config', dir: '/var/logwire-backend' })
    } catch (err) {
    }
    LogUtil.print(username, `[progress] [[1;34mInfo[m] 编译中..... \n`)
    await docker.execContainerCommand({ container, cmd: 'bash build-release.sh --module=logwire', dir: '/var/logwire-backend', quiet: true })
    await docker.execContainerCommand({ container, cmd: 'bash build-release.sh --module=assemble', dir: '/var/logwire-backend', quiet: true })
    try {
      // 打包完成后，移动默认配置文件, 修改配置文件信息
      await docker.execContainerCommand({ container, cmd: 'mv -f ../tenants_config build-output/backend/', dir: '/var/logwire-backend' })
      await docker.execContainerCommand({ container, cmd: 'chmod 755 build-output/backend/transform-miniapp.sh', dir: '/var/logwire-backend' })
    } catch (err) {
    }

    LogUtil.print(username, `[progress] [[1;34mInfo[m] 编译完成 \n`)
    await changeProjectStatus( 'v2', username, 'status', 'compiled')
  } catch (err) {
    await changeProjectStatus( 'v2', username, 'status', 'created')
    LogUtil.print(username, '[error] [[1;31mError[m]] ' + (err instanceof Error ? err.message : JSON.stringify(err)))
    setResponseStatus(event, 500)
  }
})