import fs from 'fs'

export const HOST = useRuntimeConfig().public.dockerHost

export function readJson(path: string): Record<string, any> {
  try {
    const text = fs.readFileSync(path, { encoding: 'utf-8'})
    const obj = JSON.parse(text)
    return obj
  } catch (err) {
    return {}
  }
}

export function writeJson(path: string, obj: Record<string, string>) {
  fs.writeFileSync(
    path,
    JSON.stringify(obj, null, 2)
  )
}

export function removeUnreadCharacter (str: string) {
  // return str.replace(/[\u0000-\u0009]/g, '').replace(/[\u000B-\u001F]/g, '')
  return str.replace(/\u0001\u0000\u0000\u0000\u0000\u0000\u0000\n/g, '').replace(/[\u0000-\u0009]/g, '').replace(/[\u000B-\u001F]/g, '')
}

export const SESSION_PASSWORD = '80d42cfb-1cd2-462c-8f17-e3237d9027e9'

export function sleep (ms: number) {
  return new Promise<void>((resolve, reject) => {
    setTimeout(resolve, ms)
  })
}